/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.Lazy;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;

public record GeneratedData(ResourceLocation id, Supplier<byte[]> data) implements IoSupplier<InputStream>
{
    public static final GeneratedData INTERNAL_RELOAD = new GeneratedData(KubeJS.id("__internal.reload"), Lazy.of(() -> new byte[0]));
    public static final GeneratedData PACK_META = new GeneratedData(KubeJS.id("pack.mcmeta"), Lazy.of(() -> {
        JsonObject json = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "KubeJS Pack");
        pack.addProperty("pack_format", (Number)15);
        json.add("pack", (JsonElement)pack);
        return json.toString().getBytes(StandardCharsets.UTF_8);
    }));
    public static final GeneratedData PACK_ICON = new GeneratedData(KubeJS.id("textures/kubejs_logo.png"), () -> {
        try {
            return Files.readAllBytes(KubeJS.thisMod.getModInfo().getOwningFile().getFile().findResource(new String[]{"assets", "kubejs", "textures", "kubejs_logo.png"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new byte[0];
        }
    });

    public static GeneratedData json(ResourceLocation id, Supplier<JsonElement> json) {
        return new GeneratedData(id.getPath().endsWith(".json") ? id : ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + ".json")), Lazy.of(() -> JsonIO.toString((JsonElement)json.get()).getBytes(StandardCharsets.UTF_8)));
    }

    @NotNull
    public InputStream get() {
        return new ByteArrayInputStream(this.data.get());
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeneratedData)) return false;
        GeneratedData g = (GeneratedData)obj;
        if (!this.id.equals((Object)g.id)) return false;
        return true;
    }

    @Override
    public String toString() {
        return this.id.toString();
    }
}

