/*
 * Decompiled with CFR 0.152.
 */
package com.bigenergy.ftbqopt.mixin;

import com.bigenergy.ftbqopt.config.FTBQuestsOptimizerConfig;
import com.bigenergy.ftbqopt.mixin.accessor.DeferredInventoryDetectionAccessor;
import com.bigenergy.ftbqopt.util.DetectionDebouncer;
import com.bigenergy.ftbqopt.util.LastSeenSlotCache;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import dev.ftb.mods.ftbquests.util.PlayerInventorySummary;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FTBQuestsInventoryListener.class})
public abstract class FTBQuestsInventoryListenerMixin {
    @Final
    @Shadow
    public ServerPlayer player;

    @Inject(method={"detect(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;J)V"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private static void ftbqopt$optimizedDetect(ServerPlayer player, ItemStack craftedItem, long sourceTask, CallbackInfo ci) {
        List tasksToCheck;
        ServerQuestFile file;
        if (((Boolean)FTBQuestsOptimizerConfig.DEBOUNCE.get()).booleanValue()) {
            DetectionDebouncer.markCompleted(player);
        }
        if ((file = ServerQuestFile.INSTANCE) == null || PlayerHooks.isFake((Player)player)) {
            ci.cancel();
            return;
        }
        boolean craftingPath = !craftedItem.isEmpty();
        List list = tasksToCheck = craftingPath ? file.getCraftingTasks() : file.getSubmitTasks();
        if (tasksToCheck.isEmpty()) {
            ci.cancel();
            return;
        }
        FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
            TeamData data = file.getNullableTeamData(team.getId());
            if (data == null || data.isLocked()) {
                return;
            }
            ArrayList<Task> candidates = new ArrayList<Task>(tasksToCheck.size());
            for (Task t : tasksToCheck) {
                if (t.id == sourceTask || !data.canStartTasks(t.getQuest())) continue;
                candidates.add(t);
            }
            if (candidates.isEmpty()) {
                return;
            }
            file.withPlayerContext(player, () -> {
                if (!craftingPath) {
                    PlayerInventorySummary.build((ServerPlayer)player);
                }
                for (Task task : candidates) {
                    task.submitTask(data, player, craftedItem);
                }
            });
        });
        ci.cancel();
    }

    @Inject(method={"slotChanged(Lnet/minecraft/world/inventory/AbstractContainerMenu;ILnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void ftbqopt$slotChanged(AbstractContainerMenu menu, int index, ItemStack stack, CallbackInfo ci) {
        int delay;
        if (stack.isEmpty()) {
            ci.cancel();
            return;
        }
        Slot slot = menu.getSlot(index);
        if (slot.container != this.player.getInventory()) {
            ci.cancel();
            return;
        }
        int slotNum = slot.getContainerSlot();
        int mainSize = this.player.getInventory().items.size();
        if (slotNum < 0 || slotNum >= mainSize) {
            ci.cancel();
            return;
        }
        if (((Boolean)FTBQuestsOptimizerConfig.IGNORE_NBT_ONLY.get()).booleanValue() && LastSeenSlotCache.isSameItemCount(this.player, slotNum, stack)) {
            ci.cancel();
            return;
        }
        LastSeenSlotCache.update(this.player, slotNum, stack);
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null) {
            ci.cancel();
            return;
        }
        int ftbqDelay = Mth.clamp((int)file.getDetectionDelay(), (int)0, (int)200);
        int cfg = (Integer)FTBQuestsOptimizerConfig.DELAY_OVERRIDE.get();
        int n = delay = cfg >= 0 ? cfg : ftbqDelay;
        if (delay == 0) {
            FTBQuestsInventoryListener.detect((ServerPlayer)this.player, (ItemStack)ItemStack.EMPTY, (long)0L);
            ci.cancel();
            return;
        }
        if (((Boolean)FTBQuestsOptimizerConfig.DEBOUNCE.get()).booleanValue()) {
            DetectionDebouncer.scheduleIfNotQueued(this.player, delay);
        } else {
            DeferredInventoryDetectionAccessor.ftbq$invokeScheduleInventoryCheck(this.player, delay);
        }
        ci.cancel();
    }
}

