/*
 * Decompiled with CFR 0.152.
 */
package com.bigenergy.ftbqopt.util;

import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class LastSeenSlotCache {
    private static final Map<UUID, Entry[]> CACHE = new WeakHashMap<UUID, Entry[]>();

    private LastSeenSlotCache() {
    }

    public static boolean isSameItemCount(ServerPlayer player, int slot, ItemStack current) {
        Entry[] arr = CACHE.computeIfAbsent(player.getUUID(), id -> new Entry[64]);
        Entry e = arr[slot];
        Item item = current.getItem();
        int count = current.getCount();
        return e != null && e.item == item && e.count == count;
    }

    public static void update(ServerPlayer player, int slot, ItemStack current) {
        Entry[] arr = CACHE.computeIfAbsent(player.getUUID(), id -> new Entry[64]);
        Entry e = arr[slot];
        if (e == null) {
            arr[slot] = e = new Entry();
        }
        e.item = current.getItem();
        e.count = current.getCount();
    }

    private static final class Entry {
        Item item;
        int count;

        private Entry() {
        }
    }
}

