/*
 * Decompiled with CFR 0.152.
 */
package net.kajuslion.displaythat;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;

public class ShowcaseItemFeature {
    public static float alphaValue = 1.0f;

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForMessage(GuiGraphics guiGraphics, FormattedCharSequence sequence, float x, float y, int color) {
        Minecraft mc = Minecraft.getInstance();
        StringBuilder before = new StringBuilder();
        int halfSpace = mc.font.width(" ") / 2;
        sequence.accept((counter_, style, character) -> {
            String sofar = before.toString();
            if (sofar.endsWith("  ")) {
                ShowcaseItemFeature.render(mc, guiGraphics, sofar.substring(0, sofar.length() - 2), character == 32 ? 0.0f : (float)(-halfSpace), x, y, style, color);
                return false;
            }
            before.append((char)character);
            return true;
        });
    }

    public static MutableComponent createStackComponent(ItemStack stack, MutableComponent component) {
        Style style = component.getStyle();
        int count = stack.getCount();
        if (count > 64) {
            ItemStack copyStack = stack.copy();
            copyStack.setCount(64);
            style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(copyStack)));
            component.withStyle(style);
        }
        MutableComponent icon = Component.literal((String)"   ");
        icon.setStyle(style);
        System.out.println(component);
        Style componentStyle = component.getStyle();
        MutableComponent componentCopy = component.copy();
        System.out.println(componentCopy.getContents());
        String modifiedText = componentCopy.getString().replaceAll("\\[|\\]", "");
        MutableComponent processedComponent = Component.literal((String)modifiedText).setStyle(style);
        System.out.println(processedComponent);
        MutableComponent formattedComponent = Component.literal((String)"").append((Component)Component.literal((String)"[").withStyle(ChatFormatting.DARK_GRAY));
        if (count > 1) {
            formattedComponent.append((Component)Component.literal((String)("x" + count + " ")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16776611)))).append((Component)Component.literal((String)"|").withStyle(ChatFormatting.DARK_GRAY));
        }
        formattedComponent.append((Component)Component.literal((String)" ")).append((Component)icon).append((Component)processedComponent).append((Component)Component.literal((String)"]").withStyle(ChatFormatting.DARK_GRAY));
        return formattedComponent;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void render(Minecraft mc, GuiGraphics guiGraphics, String before, float extraShift, float x, float y, Style style, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        PoseStack pose = guiGraphics.pose();
        HoverEvent hoverEvent = style.getHoverEvent();
        if (hoverEvent != null && hoverEvent.getAction() == HoverEvent.Action.SHOW_ITEM) {
            ItemStack stack;
            HoverEvent.ItemStackInfo contents = (HoverEvent.ItemStackInfo)hoverEvent.getValue(HoverEvent.Action.SHOW_ITEM);
            ItemStack itemStack = stack = contents != null ? contents.getItemStack() : ItemStack.EMPTY;
            if (stack.isEmpty()) {
                stack = new ItemStack((ItemLike)Blocks.BARRIER);
            }
            float shift = (float)mc.font.width(before) + extraShift;
            if (ModList.get().isLoaded("overflowingbars")) {
                y += Minecraft.getInstance().player.getAbsorptionAmount() > 10.0f ? 10.0f : 0.0f;
                y += (float)Minecraft.getInstance().player.getArmorValue() > 0.5f ? 10.0f : 0.0f;
            }
            if (a > 0.0f) {
                alphaValue = a;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().mulPose(pose.last().pose());
                guiGraphics.pose().translate(shift + x, y, 0.0f);
                guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
                guiGraphics.renderItem(stack, 0, 0);
                guiGraphics.pose().popPose();
                alphaValue = 1.0f;
            }
        }
    }
}

