/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.YungsApiNeoForge;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterPotion;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

public class PotionModuleNeoForge {
    public static final List<IBrewingRecipe> BREWING_RECIPES = new ArrayList<IBrewingRecipe>();

    public static void processEntries() {
        YungsApiNeoForge.loadingContextEventBus.addListener(YungsApiNeoForge.buildAutoRegistrar(Registries.POTION, AutoRegistrationManager.POTIONS, PotionModuleNeoForge::buildPotion));
        NeoForge.EVENT_BUS.addListener(PotionModuleNeoForge::registerBrewingRecipes);
    }

    private static Potion buildPotion(AutoRegisterField data) {
        AutoRegisterPotion autoRegisterPotion = (AutoRegisterPotion)data.object();
        MobEffectInstance mobEffectInstance = autoRegisterPotion.getMobEffectInstance();
        String name = data.name().getNamespace() + "." + data.name().getPath();
        Potion potion = new Potion(name, new MobEffectInstance[]{mobEffectInstance});
        autoRegisterPotion.setSupplier(() -> potion);
        return potion;
    }

    private static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        BREWING_RECIPES.forEach(recipe -> event.getBuilder().addRecipe(recipe));
    }

    public record BrewingRecipe(Supplier<Potion> input, Supplier<Item> ingredient, Supplier<Potion> output) implements IBrewingRecipe
    {
        public boolean isInput(ItemStack itemStack) {
            PotionContents potionContents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            return potionContents.is(Holder.direct((Object)this.input.get()));
        }

        public boolean isIngredient(ItemStack itemStack) {
            return itemStack.getItem() == this.ingredient.get();
        }

        public ItemStack getOutput(ItemStack inputStack, ItemStack ingredientStack) {
            return this.isInput(inputStack) && this.isIngredient(ingredientStack) ? PotionContents.createItemStack((Item)inputStack.getItem(), (Holder)Holder.direct((Object)this.output.get())) : ItemStack.EMPTY;
        }
    }
}

