/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.lance5057.extradelight.ExtraDelightBanners;
import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightCapabilities;
import com.lance5057.extradelight.ExtraDelightClientEvents;
import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.ExtraDelightConfig;
import com.lance5057.extradelight.ExtraDelightContainers;
import com.lance5057.extradelight.ExtraDelightFluids;
import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightLootModifiers;
import com.lance5057.extradelight.ExtraDelightMobEffects;
import com.lance5057.extradelight.ExtraDelightPaintings;
import com.lance5057.extradelight.ExtraDelightParticles;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.ExtraDelightTabs;
import com.lance5057.extradelight.ExtraDelightWorldGen;
import com.lance5057.extradelight.PottedPlants;
import com.lance5057.extradelight.aesthetics.AestheticBlocks;
import com.lance5057.extradelight.modules.Fermentation;
import com.lance5057.extradelight.modules.SummerCitrus;
import com.lance5057.extradelight.network.NetworkHandler;
import com.lance5057.extradelight.worldgen.features.ExtraDelightFeatures;
import com.lance5057.extradelight.worldgen.placers.FoliagePlacerRegistry;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="extradelight")
public class ExtraDelight {
    public static final String MOD_ID = "extradelight";
    public static final String VERSION = "2.6.1";
    public static Logger logger = LogManager.getLogger();

    public static ResourceLocation modLoc(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)s);
    }

    public ExtraDelight(IEventBus modEventBus, ModContainer modContainer) {
        NeoForgeMod.enableMilkFluid();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ExtraDelightConfig.spec);
        modEventBus.addListener(this::setupClient);
        modEventBus.addListener(this::setupCommon);
        modEventBus.addListener(ExtraDelightCapabilities::registerCapabilities);
        modEventBus.addListener(NetworkHandler::setupPackets);
        modEventBus.addListener(ExtraDelightBlockEntities::addCabinets);
        Fermentation f = new Fermentation();
        SummerCitrus s = new SummerCitrus();
        AestheticBlocks.setup();
        AestheticBlocks.BLOCKS.register(modEventBus);
        AestheticBlocks.ITEMS.register(modEventBus);
        ExtraDelightComponents.COMPONENTS.register(modEventBus);
        ExtraDelightBlocks.register(modEventBus);
        ExtraDelightFluids.register(modEventBus);
        ExtraDelightItems.ITEMS.register(modEventBus);
        ExtraDelightTabs.TABS.register(modEventBus);
        ExtraDelightPaintings.PAINTING_VARIANTS.register(modEventBus);
        ExtraDelightBanners.BANNER_PATTERNS.register(modEventBus);
        ExtraDelightBlockEntities.TILES.register(modEventBus);
        ExtraDelightRecipes.RECIPE_TYPES.register(modEventBus);
        ExtraDelightRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        ExtraDelightContainers.MENU_TYPES.register(modEventBus);
        ExtraDelightLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        FoliagePlacerRegistry.PLACER.register(modEventBus);
        ExtraDelightWorldGen.FEATURES.register(modEventBus);
        ExtraDelightFeatures.FEATURES.register(modEventBus);
        ExtraDelightMobEffects.register(modEventBus);
        ExtraDelightParticles.PARTICLE_TYPES.register(modEventBus);
    }

    public void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ExtraDelightClientEvents.setTERenderers();
            ExtraDelightClientEvents.doFluidRenderLayer();
        });
    }

    public void setupCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ExtraDelightBlocks.setup();
            ExtraDelightItems.setup();
            PottedPlants.setup();
            ExtraDelight.registerItemSetAdditions();
        });
    }

    public static void registerItemSetAdditions() {
        HashSet newWantedItems = Sets.newHashSet((Object[])new Item[]{(Item)ExtraDelightItems.CHILI.get(), (Item)ExtraDelightItems.GINGER.get(), (Item)ExtraDelightItems.GARLIC.get(), (Item)Fermentation.CUCUMBER.get()});
        newWantedItems.addAll(Villager.WANTED_ITEMS);
        Villager.WANTED_ITEMS = ImmutableSet.copyOf((Collection)newWantedItems);
    }
}

