/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.countercabinet;

import com.lance5057.extradelight.blocks.countercabinet.CounterCabinetBlock;
import com.lance5057.extradelight.blocks.countercabinet.CounterCabinetBlockEntity;
import com.lance5057.extradelight.util.RenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.renderable.BakedModelRenderable;
import net.neoforged.neoforge.client.model.renderable.ITextureRenderTypeLookup;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class CounterCabinetRenderer
implements BlockEntityRenderer<CounterCabinetBlockEntity> {
    public CounterCabinetRenderer(BlockEntityRendererProvider.Context p_173621_) {
    }

    public void render(CounterCabinetBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Direction[] directionArray;
        if (!pBlockEntity.hasLevel()) {
            return;
        }
        ItemStack item = pBlockEntity.getItemHandler().getStackInSlot(27);
        ArrayList<BakedQuad> copiedQuads = new ArrayList<BakedQuad>();
        if (item != null && !item.isEmpty() && (directionArray = item.getItem()) instanceof BlockItem) {
            BlockItem b = (BlockItem)directionArray;
            for (Direction d : Direction.values()) {
                List q = Minecraft.getInstance().getBlockRenderer().getBlockModel(b.getBlock().defaultBlockState()).getQuads(b.getBlock().defaultBlockState(), d, pBlockEntity.getLevel().random, ModelData.EMPTY, RenderType.cutout());
                if (q.isEmpty()) continue;
                copiedQuads.add((BakedQuad)q.get(0));
            }
            pPoseStack.pushPose();
            float f = ((Direction)pBlockEntity.getBlockState().getValue((Property)CounterCabinetBlock.FACING)).getClockWise().toYRot();
            pPoseStack.translate(0.5f, 0.0f, 0.5f);
            pPoseStack.mulPose(Axis.YP.rotationDegrees(-f - 90.0f));
            pPoseStack.translate(-0.5f, 0.0f, -0.5f);
            this.render(pPoseStack, pBufferSource, texture -> RenderType.entityTranslucent((ResourceLocation)texture), pPackedLight, pPackedOverlay, pPartialTick, new BakedModelRenderable.Context(ModelData.EMPTY), pBlockEntity.getBlockPos(), copiedQuads);
            pPoseStack.popPose();
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, ITextureRenderTypeLookup textureRenderTypeLookup, int lightmap, int overlay, float partialTick, BakedModelRenderable.Context context, BlockPos pos, List<BakedQuad> copiedQuads) {
        float f = Mth.sqrt((float)5.0f);
        float f1 = Mth.sqrt((float)14.0f);
        poseStack.pushPose();
        poseStack.translate(-0.001f, 0.001f, -0.001f);
        float scale = 1.002f;
        poseStack.scale(scale, scale, scale);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        PoseStack.Pose posestack$pose = poseStack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        Matrix3f matrix3f = posestack$pose.normal();
        if (copiedQuads != null && !copiedQuads.isEmpty()) {
            Vector4f uvTop = RenderUtil.ZERO4;
            Vector4f uvBottom = RenderUtil.ZERO4;
            Vector4f uvNorth = RenderUtil.ZERO4;
            Vector4f uvSouth = RenderUtil.ZERO4;
            Vector4f uvEast = RenderUtil.ZERO4;
            Vector4f uvWest = RenderUtil.ZERO4;
            if (copiedQuads.size() > 1 && copiedQuads.get(1) != null) {
                uvBottom = RenderUtil.getUVFromSprite(copiedQuads.get(1).getSprite(), 0.0f, 0.0f, 16.0f, 16.0f);
            }
            if (copiedQuads.size() > 2 && copiedQuads.get(2) != null) {
                uvNorth = RenderUtil.getUVFromSprite(copiedQuads.get(2).getSprite(), 0.0f, 0.0f, 16.0f, 2.0f);
            }
            if (copiedQuads.size() > 3 && copiedQuads.get(3) != null) {
                uvSouth = RenderUtil.getUVFromSprite(copiedQuads.get(3).getSprite(), 0.0f, 0.0f, 16.0f, 2.0f);
            }
            if (copiedQuads.size() > 4 && copiedQuads.get(4) != null) {
                uvEast = RenderUtil.getUVFromSprite(copiedQuads.get(4).getSprite(), 0.0f, 0.0f, 16.0f, 2.0f);
            }
            if (copiedQuads.size() > 5 && copiedQuads.get(5) != null) {
                uvWest = RenderUtil.getUVFromSprite(copiedQuads.get(5).getSprite(), 0.0f, 0.0f, 16.0f, 2.0f);
            }
            RenderUtil.buildCube(new Vector3f(0.0f, 0.875f, 0.0f), new Vector3f(1.0f, 0.125f, 1.0f), vertexconsumer, matrix4f, matrix3f, RenderUtil.WHITE, lightmap, OverlayTexture.NO_OVERLAY, poseStack, null, uvBottom, uvNorth, uvSouth, uvEast, uvWest);
            if (copiedQuads.size() > 1 && copiedQuads.get(1) != null) {
                uvBottom = RenderUtil.getUVFromSprite(copiedQuads.get(1).getSprite(), 0.0f, 0.0f, 2.0f, 16.0f);
            }
            if (copiedQuads.size() > 2 && copiedQuads.get(2) != null) {
                uvNorth = RenderUtil.getUVFromSprite(copiedQuads.get(2).getSprite(), 0.0f, 0.0f, 16.0f, 2.0f);
            }
            if (copiedQuads.size() > 3 && copiedQuads.get(3) != null) {
                uvSouth = RenderUtil.getUVFromSprite(copiedQuads.get(3).getSprite(), 0.0f, 0.0f, 16.0f, 2.0f);
            }
            if (copiedQuads.size() > 4 && copiedQuads.get(4) != null) {
                uvEast = RenderUtil.getUVFromSprite(copiedQuads.get(4).getSprite(), 0.0f, 0.0f, 2.0f, 2.0f);
            }
            if (copiedQuads.size() > 5 && copiedQuads.get(5) != null) {
                uvWest = RenderUtil.getUVFromSprite(copiedQuads.get(5).getSprite(), 0.0f, 0.0f, 2.0f, 2.0f);
            }
            RenderUtil.buildCube(new Vector3f(0.0f, 1.0f, 0.875f), new Vector3f(1.0f, 0.125f, 0.125f), vertexconsumer, matrix4f, matrix3f, RenderUtil.WHITE, lightmap, OverlayTexture.NO_OVERLAY, poseStack, null, uvBottom, uvNorth, uvSouth, uvEast, uvWest);
        }
        poseStack.popPose();
    }
}

