/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.crops.corn;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightConfig;
import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightWorldGen;
import com.lance5057.extradelight.blocks.crops.corn.CornProperties;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class CornTop
extends CropBlock
implements Portal {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final BooleanProperty DENSE = BooleanProperty.create((String)"dense");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)};

    public CornTop(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)CornProperties.DIMENSION, (Comparable)Boolean.valueOf(false))).setValue((Property)DENSE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[(Integer)pState.getValue((Property)this.getAgeProperty())];
    }

    protected boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.is(Blocks.FARMLAND);
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public int getAge(BlockState pState) {
        return (Integer)pState.getValue((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int pAge) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(pAge));
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return !this.isMaxAge(pState) && (Boolean)pState.getValue((Property)CornProperties.DIMENSION) == false;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        float f;
        int i;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.getRawBrightness(pPos, 0) >= 9 && (i = this.getAge(pState)) < this.getMaxAge() && CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.nextInt((int)(25.0f / (f = CropBlock.getGrowthSpeed((BlockState)pState, (BlockGetter)pLevel, (BlockPos)pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            pLevel.setBlock(pPos, this.getStateForAge(i + 1), 3);
            CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState s = super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        if (s.getBlock() == ExtraDelightBlocks.CORN_TOP.get() && this.isMaxAge(pState) && this.checkSides(pLevel, pCurrentPos.east()) && this.checkSides(pLevel, pCurrentPos.north()) && this.checkSides(pLevel, pCurrentPos.west()) && this.checkSides(pLevel, pCurrentPos.south())) {
            pLevel.setBlock(pCurrentPos, (BlockState)s.setValue((Property)DENSE, (Comparable)Boolean.valueOf(true)), 3);
        }
        return s;
    }

    boolean checkSides(LevelAccessor pLevel, BlockPos pos) {
        BlockState e = pLevel.getBlockState(pos);
        if (e.getBlock() instanceof CornTop) {
            return this.isMaxAge(e);
        }
        return false;
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState pState) {
        int j;
        int i = this.getAge(pState) + this.getBonemealAgeIncrease(pLevel);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        pLevel.setBlock(pPos, this.getStateForAge(i), 2);
    }

    protected int getBonemealAgeIncrease(Level pLevel) {
        return Mth.nextInt((RandomSource)pLevel.random, (int)0, (int)1);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (((Boolean)pState.getValue((Property)CornProperties.DIMENSION)).booleanValue()) {
            return true;
        }
        return (pLevel.getRawBrightness(pPos, 0) >= 8 || pLevel.canSeeSky(pPos)) && pLevel.getBlockState(pPos.below()).getBlock() == ExtraDelightBlocks.CORN_BOTTOM.get();
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.entityInside(pState, pLevel, pPos, pEntity);
        if (pEntity instanceof Player) {
            Player p = (Player)pEntity;
            boolean b = (Boolean)pState.getValue((Property)DENSE);
            if (b && CornTop.isHalloween()) {
                if (p.hasEffect(MobEffects.CONFUSION)) {
                    MobEffectInstance mei = p.getEffect(MobEffects.CONFUSION);
                    if (mei.getDuration() <= 3) {
                        pEntity.setPortalCooldown(0);
                        pEntity.setAsInsidePortal((Portal)this, pPos);
                    }
                } else if (pLevel.random.nextInt(100) == 0) {
                    p.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200));
                }
            }
        }
        if (((Boolean)pState.getValue((Property)CornProperties.DIMENSION)).booleanValue()) {
            if (pEntity.isSprinting()) {
                pEntity.hurt(pEntity.damageSources().sweetBerryBush(), 1.0f);
            }
            pEntity.makeStuckInBlock(pState, new Vec3(0.8, 0.75, 0.4));
        }
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return true;
    }

    private static boolean isHalloween() {
        if (!ExtraDelightConfig.ALL_YEAR.getAsBoolean()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            return j == 10 && i >= 1 || j == 11 && i <= 10;
        }
        return true;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ExtraDelightItems.CORN_SEEDS.get();
    }

    public ItemStack getCloneItemStack(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack(this.getBaseSeedId());
    }

    public boolean isValidBonemealTarget(BlockGetter pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return !this.isMaxAge(pState);
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        this.growCrops((Level)pLevel, pPos, pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE, CornProperties.DIMENSION, DENSE});
    }

    public void destroy(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.getValue((Property)CornProperties.DIMENSION)).booleanValue()) {
            pLevel.setBlock(pPos, pState, 4);
        }
    }

    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        ServerLevel serverlevel = level.getServer().getLevel(ExtraDelightWorldGen.CORNFIELD);
        if (serverlevel == null) {
            return null;
        }
        return new DimensionTransition(serverlevel, new Vec3(entity.getX(), 33.0, entity.getZ()), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.DO_NOTHING);
    }

    public Portal.Transition getLocalTransition() {
        return Portal.Transition.CONFUSION;
    }
}

