/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.jardisplay;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.blocks.IDisplayInteractable;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class JarDisplayBlockEntity
extends BlockEntity {
    public static final String TAG = "inv";
    private final ItemStackHandler items = this.createHandler();
    private final Lazy<IItemHandler> itemHandler = Lazy.of(() -> this.items);
    public static final int NUM_SLOTS = 4;

    public JarDisplayBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ExtraDelightBlockEntities.JAR_DISPLAY.get(), pos, blockState);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            public boolean isItemValid(int slot, ItemStack stack) {
                Item item = stack.getItem();
                if (item instanceof BlockItem) {
                    BlockItem bi = (BlockItem)item;
                    if (bi.getBlock() instanceof IDisplayInteractable) {
                        return true;
                    }
                    if (bi instanceof IDisplayInteractable) {
                        return true;
                    }
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                JarDisplayBlockEntity.this.requestModelDataUpdate();
                JarDisplayBlockEntity.this.getLevel().sendBlockUpdated(JarDisplayBlockEntity.this.getBlockPos(), JarDisplayBlockEntity.this.getBlockState(), JarDisplayBlockEntity.this.getBlockState(), 2);
                JarDisplayBlockEntity.this.setChanged();
            }
        };
    }

    public IItemHandler getItems() {
        return (IItemHandler)this.itemHandler.get();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        if (tag != null) {
            this.readNBT(tag, registries);
        }
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains(TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(TAG));
        }
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(TAG, (Tag)this.items.serializeNBT(registries));
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }
}

