/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.jardisplay;

import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.blocks.IDisplayInteractable;
import com.lance5057.extradelight.blocks.jardisplay.JarDisplayBlockEntity;
import com.lance5057.extradelight.blocks.jardisplay.JarSingularBlock;
import com.lance5057.extradelight.recipe.FeastRecipe;
import com.lance5057.extradelight.recipe.SimpleRecipeWrapper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class JarSingularItem
extends BlockItem
implements IDisplayInteractable {
    public JarSingularItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public ItemInteractionResult itemInteract(ItemStack heldItem, ItemStack interactItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        BlockItemStateProperties itemState = (BlockItemStateProperties)interactItem.get(DataComponents.BLOCK_STATE);
        int servings = (Integer)itemState.get((Property)JarSingularBlock.SERVINGS);
        if (servings == 0) {
            level.playSound(null, pos, SoundEvents.WOOD_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack heldheldItem = player.getItemInHand(hand);
        Optional r = level.getRecipeManager().getRecipeFor(ExtraDelightRecipes.FEAST.get(), (RecipeInput)new SimpleRecipeWrapper(interactItem, heldItem), level);
        if (r.isPresent()) {
            if (servings > 0) {
                ItemStack output = ((FeastRecipe)((RecipeHolder)r.get()).value()).getResultItem((HolderLookup.Provider)player.level().registryAccess()).copy();
                interactItem.update(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY, s -> s.with((Property)JarSingularBlock.SERVINGS, (Comparable)Integer.valueOf(servings - 1)));
                if (!player.getAbilities().instabuild) {
                    if (heldheldItem.isDamageableItem()) {
                        heldheldItem.hurtAndBreak(1, (LivingEntity)player, null);
                    } else {
                        heldheldItem.shrink(1);
                    }
                }
                if (!player.getInventory().add(output)) {
                    player.drop(output, false);
                }
                level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.sendBlockUpdated(pos, state, state, 3);
                return ItemInteractionResult.SUCCESS;
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"extradelight.block.recipefeast.use_container"), true);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void extractItem(Level level, BlockPos pos, Player player, JarDisplayBlockEntity jdbe, ItemStackHandler handler, ItemStack s, int index) {
        if (!player.addItem(s)) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), s.copy()));
            handler.setStackInSlot(index, ItemStack.EMPTY);
        }
    }

    @Override
    public void convertToSingular(BlockPos pos, Level level, JarDisplayBlockEntity jdbe, ItemStack stack) {
        BlockState bs = this.getBlock().defaultBlockState();
        if (stack.has(DataComponents.BLOCK_STATE)) {
            bs = ((BlockItemStateProperties)stack.get(DataComponents.BLOCK_STATE)).apply(bs);
        }
        level.setBlock(pos, bs, 2);
    }
}

