/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.keg;

import com.lance5057.extradelight.blocks.keg.KegBlockEntity;
import com.lance5057.extradelight.util.RenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class KegRenderer
implements BlockEntityRenderer<KegBlockEntity> {
    final ResourceLocation kegTop = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"block/keg_top");
    final ResourceLocation kegBottom = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"block/keg_bottom");
    final ResourceLocation kegSide = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"block/keg_side");

    public KegRenderer(BlockEntityRendererProvider.Context p_173621_) {
    }

    public void render(KegBlockEntity tank, float tickDelta, PoseStack ps, MultiBufferSource mbs, int light, int overlay) {
        VertexConsumer vertexConsumer = mbs.getBuffer(Sheets.translucentCullBlockSheet());
        Matrix4f mat = ps.last().pose();
        Matrix3f matrix3f = ps.last().normal();
        ps.pushPose();
        RenderUtil.buildInvertedCubePillar(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), vertexConsumer, mat, matrix3f, -1, 0xF00000, RenderUtil.getUV(this.kegSide), RenderUtil.getUV(this.kegTop), RenderUtil.getUV(this.kegBottom), overlay, ps);
        ps.popPose();
        if (!tank.getTank().getFluid().isEmpty()) {
            ps.pushPose();
            FluidStack fluidStack = tank.getTank().getFluid();
            Fluid fluid = fluidStack.getFluid();
            IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            RenderUtil.buildCubeAll(new Vector3f(0.0625f, 0.0625f, 0.0625f), new Vector3f(0.875f, tank.getFullness() * 0.875f, 0.875f), vertexConsumer, mat, matrix3f, fluidTypeExtensions.getTintColor(fluidStack), RenderUtil.getUV(fluidTypeExtensions.getStillTexture()), 0xF00000, overlay, ps);
            ps.popPose();
        }
    }
}

