/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.sink;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.capabilities.WellFluidCapability;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class SinkCabinetBlockEntity
extends BlockEntity {
    WellFluidCapability water = new WellFluidCapability((Fluid)Fluids.WATER);
    private final Lazy<IFluidHandler> fluidHandler = Lazy.of(() -> this.water);
    public static final String TAG = "inv";
    private final ItemStackHandler items = this.createHandler();
    private final Lazy<IItemHandler> itemHandler = Lazy.of(() -> this.items);
    public static final int NUM_SLOTS = 19;

    public SinkCabinetBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ExtraDelightBlockEntities.SINK_BLOCK.get(), pPos, pState);
    }

    public IFluidHandler getFluidHandler() {
        return (IFluidHandler)this.fluidHandler.get();
    }

    public ItemStack fill(ItemStack stack, Player player) {
        if (stack.getCapability(Capabilities.FluidHandler.ITEM) != null) {
            FluidActionResult r = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)this.water, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            return r.result;
        }
        return stack;
    }

    public ItemStack drain(ItemStack stack, Player player) {
        FluidActionResult r = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)this.water, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        return r.result;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(19);
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public IItemHandler getItemHandler() {
        return (IItemHandler)this.itemHandler.get();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains(TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(TAG));
        }
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(TAG, (Tag)this.items.serializeNBT(registries));
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }

    public String getDisplayName() {
        return "screen.sink.name";
    }
}

