/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data.recipebuilders;

import com.lance5057.extradelight.workstations.chiller.ChillerRecipe;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.CrashReport;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class ChillerRecipeBuilder
implements RecipeBuilder {
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private final Item result;
    private final ItemStack resultStack;
    private final int cookingTime;
    private final float experience;
    private final ItemStack container;
    private final FluidStack fluid;
    private final Boolean consumeContainer;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private ChillerRecipeBuilder(ItemStack resultIn, int cookingTime, float experience, ItemStack container, FluidStack fluid, boolean consumeContainer) {
        this.result = resultIn.getItem();
        this.resultStack = resultIn;
        this.cookingTime = cookingTime;
        this.experience = experience;
        this.container = container;
        this.fluid = fluid;
        this.consumeContainer = consumeContainer;
    }

    public static ChillerRecipeBuilder chill(ItemStack mainResult, int cookingTime, float experience, ItemStack container, FluidStack fluid) {
        return new ChillerRecipeBuilder(mainResult, cookingTime, experience, container, fluid, false);
    }

    public static ChillerRecipeBuilder chill(ItemStack mainResult, int cookingTime, float experience, ItemStack container, FluidStack fluid, boolean consumeContainer) {
        return new ChillerRecipeBuilder(mainResult, cookingTime, experience, container, fluid, consumeContainer);
    }

    public ChillerRecipeBuilder addIngredient(TagKey<Item> tagIn) {
        return this.addIngredient(Ingredient.of(tagIn));
    }

    public ChillerRecipeBuilder addIngredient(TagKey<Item> itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredient(Ingredient.of(itemIn));
        }
        return this;
    }

    public ChillerRecipeBuilder addIngredient(ItemLike itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public ChillerRecipeBuilder addIngredient(ItemLike itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{itemIn}));
        }
        return this;
    }

    public ChillerRecipeBuilder addIngredient(Ingredient ingredientIn) {
        return this.addIngredient(ingredientIn, 1);
    }

    public ChillerRecipeBuilder addIngredient(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredientToList(ingredientIn);
        }
        return this;
    }

    private void addIngredientToList(Ingredient i) {
        if (this.ingredients.size() > 3) {
            Minecraft.crash(null, (File)new File(""), (CrashReport)CrashReport.forThrowable((Throwable)new Throwable(), (String)"Chiller cannot accept more than 4 items! Waah!"));
        } else {
            this.ingredients.add((Object)i);
        }
    }

    public ChillerRecipeBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.criteria.put(criterionName, criterionTrigger);
        return this;
    }

    public ChillerRecipeBuilder unlockedByItems(String criterionName, ItemLike ... items) {
        return this.unlockedBy(criterionName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
    }

    public ChillerRecipeBuilder unlockedByAnyIngredient(ItemLike ... items) {
        this.criteria.put("has_any_ingredient", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(items).build()}));
        return this;
    }

    public void build(RecipeOutput consumer) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)this.result);
        this.build(consumer, "extradelight:" + location.getPath());
    }

    public void build(RecipeOutput consumerIn, String save) {
        this.save(consumerIn, ResourceLocation.parse((String)save));
    }

    public RecipeBuilder group(String p_176495_) {
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        ResourceLocation recipeId = id.withPrefix("chilling/");
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        ChillerRecipe recipe = new ChillerRecipe("", this.ingredients, this.fluid, this.resultStack, this.container, this.experience, this.cookingTime, this.consumeContainer);
        output.accept(recipeId, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/chilling/")));
    }
}

