/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data.recipebuilders;

import com.lance5057.extradelight.ExtraDelight;
import com.lance5057.extradelight.recipe.FeastRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class FeastRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category = RecipeCategory.FOOD;
    private final ItemStack result;
    private final Ingredient ingredient;
    private final BlockItem block;
    @Nullable
    private String group = "";
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private FeastRecipeBuilder(ItemStack pResult, Ingredient pIngredient, BlockItem block) {
        this.result = pResult;
        this.ingredient = pIngredient;
        this.block = block;
    }

    public static FeastRecipeBuilder feast(Ingredient pIngredient, ItemStack pResult, Item block) {
        if (block instanceof BlockItem) {
            BlockItem b1 = (BlockItem)block;
            return new FeastRecipeBuilder(pResult, pIngredient, b1);
        }
        ExtraDelight.logger.error("FeastRecipeBuilder Invalid! " + block.toString() + " is not a BlockItem!");
        return null;
    }

    public FeastRecipeBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.criteria.put(criterionName, criterionTrigger);
        return this;
    }

    public FeastRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        ResourceLocation recipeId = id.withPrefix("feast/");
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        FeastRecipe recipe = new FeastRecipe(this.group, this.block, this.ingredient, this.result);
        output.accept(recipeId, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/feast/")));
    }
}

