/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data.recipebuilders;

import com.lance5057.extradelight.workstations.meltingpot.MeltingPotRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;

public class MeltingPotRecipeBuilder
implements RecipeBuilder {
    private String group = "";
    private final Ingredient input;
    private final int cooktime;
    private final FluidStack output;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public MeltingPotRecipeBuilder(Ingredient input, int cooktime, FluidStack output) {
        this.input = input;
        this.cooktime = cooktime;
        this.output = output;
    }

    public static MeltingPotRecipeBuilder melt(Ingredient in, int time, FluidStack out) {
        return new MeltingPotRecipeBuilder(in, time, out);
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public RecipeBuilder group(String groupName) {
        this.group = groupName;
        return this;
    }

    public Item getResult() {
        return Items.AIR;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        ResourceLocation recipeId = id.withPrefix("melting/");
        Advancement.Builder advancementBuilder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        MeltingPotRecipe recipe = new MeltingPotRecipe(this.input, this.cooktime, this.output, this.group);
        recipeOutput.accept(recipeId, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/melting/")));
    }
}

