/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data.recipebuilders;

import com.lance5057.extradelight.ExtraDelightTags;
import com.lance5057.extradelight.workstations.mixingbowl.recipes.MixingBowlRecipe;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class MixingBowlRecipeBuilder
implements RecipeBuilder {
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private final NonNullList<SizedFluidIngredient> fluids = NonNullList.create();
    @Nullable
    private String group;
    final int stirs;
    final ItemStack container;
    final Ingredient utensil;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public MixingBowlRecipeBuilder(ItemStack pResult, int stirs, ItemStack container, Ingredient utensil) {
        this.stirs = stirs;
        this.container = container;
        this.result = pResult;
        this.utensil = utensil;
    }

    public static MixingBowlRecipeBuilder stir(ItemStack pResult, int grinds, ItemStack container) {
        return new MixingBowlRecipeBuilder(pResult, grinds, container, Ingredient.of(ExtraDelightTags.SPOONS));
    }

    public static MixingBowlRecipeBuilder stir(ItemStack pResult, int grinds, ItemStack container, Ingredient utensil) {
        return new MixingBowlRecipeBuilder(pResult, grinds, container, utensil);
    }

    public MixingBowlRecipeBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.criteria.put(criterionName, criterionTrigger);
        return this;
    }

    public MixingBowlRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public MixingBowlRecipeBuilder requires(Ingredient pIngredient) {
        return this.requires(pIngredient, 1);
    }

    public MixingBowlRecipeBuilder requires(Ingredient pIngredient, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.ingredients.add((Object)pIngredient);
        }
        return this;
    }

    public MixingBowlRecipeBuilder requires(SizedFluidIngredient stack) {
        this.fluids.add((Object)stack);
        return this;
    }

    public MixingBowlRecipeBuilder requires(TagKey<Item> pTag) {
        return this.requires(Ingredient.of(pTag));
    }

    public MixingBowlRecipeBuilder requires(ItemLike pItem) {
        return this.requires(pItem, 1);
    }

    public MixingBowlRecipeBuilder requires(ItemLike pItem, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.requires(Ingredient.of((ItemLike[])new ItemLike[]{pItem}));
        }
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        if (this.ingredients.size() > 9) {
            throw new IllegalStateException("Mixing Bowl Recipe " + String.valueOf(id) + " has more than 9 ingredients!");
        }
        ResourceLocation recipeId = id.withPrefix("mixing/");
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        MixingBowlRecipe recipe = new MixingBowlRecipe("", this.ingredients, (List<SizedFluidIngredient>)this.fluids, this.result, this.stirs, this.container, this.utensil);
        output.accept(recipeId, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/mixing/")));
    }
}

