/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data.recipebuilders;

import com.lance5057.extradelight.workstations.mortar.recipes.MortarRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;

public class MortarRecipeBuilder
implements RecipeBuilder {
    private final ItemStack result;
    private final Ingredient ingredient;
    private final int grinds;
    private final FluidStack fluid;
    @Nullable
    private String group;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private MortarRecipeBuilder(ItemStack pResult, Ingredient pIngredient, FluidStack fluidOut, int pGrind) {
        this.result = pResult;
        this.ingredient = pIngredient;
        this.grinds = pGrind;
        this.fluid = fluidOut;
    }

    public static MortarRecipeBuilder grind(Ingredient pIngredient, ItemStack pResult, FluidStack fluidOut, int grinds) {
        return new MortarRecipeBuilder(pResult, pIngredient, fluidOut, grinds);
    }

    public MortarRecipeBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.criteria.put(criterionName, criterionTrigger);
        return this;
    }

    public MortarRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item getResult() {
        if (this.result != null) {
            return this.result.getItem();
        }
        return Items.AIR;
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        ResourceLocation recipeId = id.withPrefix("mortar/");
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        MortarRecipe recipe = new MortarRecipe("", this.ingredient, this.result, this.fluid, this.grinds);
        output.accept(recipeId, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/mortar/")));
    }
}

