/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data.recipebuilders;

import com.lance5057.extradelight.workstations.vat.recipes.VatRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class VatRecipeBuilder
implements RecipeBuilder {
    final ItemStack containerItem;
    @Nullable
    private String group;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients = NonNullList.create();
    final NonNullList<VatRecipe.StageIngredient> stageIngredients = NonNullList.create();
    SizedFluidIngredient fluid;
    protected int stages = 0;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public VatRecipeBuilder(ItemStack pResult, ItemStack containerItem) {
        this.containerItem = containerItem;
        this.result = pResult;
    }

    public static VatRecipeBuilder pickle(ItemStack pResult, ItemStack usedItem) {
        return new VatRecipeBuilder(pResult, usedItem);
    }

    public VatRecipeBuilder requiresFluid(SizedFluidIngredient stack) {
        this.fluid = stack;
        return this;
    }

    public VatRecipeBuilder requires(Ingredient pIngredient) {
        return this.requires(pIngredient, 1);
    }

    public VatRecipeBuilder requires(Ingredient pIngredient, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.ingredients.add((Object)pIngredient);
        }
        return this;
    }

    public VatRecipeBuilder requires(TagKey<Item> pTag) {
        return this.requires(Ingredient.of(pTag));
    }

    public VatRecipeBuilder requires(ItemLike pItem) {
        return this.requires(pItem, 1);
    }

    public VatRecipeBuilder requires(ItemLike pItem, int pQuantity) {
        for (int i = 0; i < pQuantity; ++i) {
            this.requires(Ingredient.of((ItemLike[])new ItemLike[]{pItem}));
        }
        return this;
    }

    public VatRecipeBuilder requiresStage(VatRecipe.StageIngredient pIngredient) {
        this.stageIngredients.add((Object)pIngredient);
        ++this.stages;
        return this;
    }

    public RecipeBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.criteria.put(criterionName, criterionTrigger);
        return this;
    }

    public VatRecipeBuilder group(String groupName) {
        this.group = groupName;
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        if (this.ingredients.size() > 6) {
            throw new IllegalStateException("Vat Recipe " + String.valueOf(id) + " has more than 6 ingredients!");
        }
        ResourceLocation recipeId = id.withPrefix("vat/");
        Advancement.Builder advancementBuilder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        VatRecipe recipe = new VatRecipe("", this.ingredients, this.stageIngredients, this.fluid, this.result, this.stages, this.containerItem);
        recipeOutput.accept(recipeId, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/vat/")));
    }
}

