/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.fluids;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import org.antlr.v4.runtime.misc.NotNull;
import org.joml.Vector3f;

public class BasicFluid
extends FluidType {
    private final ResourceLocation STILL;
    private final ResourceLocation FLOW;
    private final ResourceLocation OVERLAY;
    private final ResourceLocation VIEW_OVERLAY;
    final int tint;
    final int overlay_tint;
    float far = 24.0f;
    float near = -48.0f;

    public BasicFluid(String name, int tint, int overlay, FluidType.Properties properties) {
        super(properties);
        this.STILL = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)("liquid/" + name + "_still"));
        this.FLOW = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)("liquid/" + name + "_flow"));
        this.OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)("liquid/" + name + "_still"));
        this.VIEW_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)("textures/liquid/" + name + "_overlay.png"));
        this.tint = tint;
        this.overlay_tint = overlay;
    }

    public BasicFluid(int tint, int overlay, FluidType.Properties properties) {
        super(properties);
        this.STILL = ResourceLocation.withDefaultNamespace((String)"block/water_still");
        this.FLOW = ResourceLocation.withDefaultNamespace((String)"block/water_flow");
        this.OVERLAY = ResourceLocation.withDefaultNamespace((String)"block/water_overlay");
        this.VIEW_OVERLAY = ResourceLocation.withDefaultNamespace((String)"textures/block/water_still.png");
        this.tint = tint;
        this.overlay_tint = overlay;
    }

    public BasicFluid setFarDistance(float d) {
        this.far = d;
        return this;
    }

    public BasicFluid setNearDistance(float d) {
        this.near = d;
        return this;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return BasicFluid.this.STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return BasicFluid.this.FLOW;
            }

            public ResourceLocation getOverlayTexture() {
                return BasicFluid.this.OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return BasicFluid.this.VIEW_OVERLAY;
            }

            public int getTintColor() {
                return BasicFluid.this.tint;
            }

            public int getOverlayTint() {
                return BasicFluid.this.overlay_tint;
            }

            public float getNearFog() {
                return BasicFluid.this.near;
            }

            public float getFarFog() {
                return BasicFluid.this.far;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                int color = this.getOverlayTint();
                return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f * 0.75f, (float)(color >> 8 & 0xFF) / 255.0f * 0.75f, (float)(color & 0xFF) / 255.0f * 0.75f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                nearDistance = this.getNearFog();
                farDistance = this.getFarFog();
                if (farDistance > renderDistance) {
                    farDistance = renderDistance;
                    shape = FogShape.CYLINDER;
                }
                RenderSystem.setShaderFogStart((float)nearDistance);
                RenderSystem.setShaderFogEnd((float)farDistance);
                RenderSystem.setShaderFogShape((FogShape)shape);
            }
        });
    }
}

