/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.fluids;

import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class FluidRegistration {
    public final DeferredHolder<FluidType, FluidType> TYPE;
    public final DeferredHolder<Fluid, BaseFlowingFluid.Source> FLUID;
    public final DeferredHolder<Fluid, BaseFlowingFluid.Flowing> FLUID_FLOWING;

    private BaseFlowingFluid.Properties properties(Supplier<? extends LiquidBlock> block, Supplier<? extends Item> bucket) {
        return new BaseFlowingFluid.Properties(this.TYPE, this.FLUID, this.FLUID_FLOWING).block(block).bucket(bucket).tickRate(5);
    }

    public FluidRegistration(String name, Supplier<? extends FluidType> fluid, Supplier<? extends LiquidBlock> block, Supplier<? extends Item> bucket, DeferredRegister<FluidType> FLUID_TYPES, DeferredRegister<Fluid> FLUIDS) {
        this.TYPE = FLUID_TYPES.register(name + "_fluid", fluid);
        this.FLUID = FLUIDS.register(name + "_fluid", () -> new BaseFlowingFluid.Source(this.properties(block, bucket)));
        this.FLUID_FLOWING = FLUIDS.register(name + "_fluid_flowing", () -> new BaseFlowingFluid.Flowing(this.properties(block, bucket)));
    }

    public FluidRegistration(String name, Supplier<? extends FluidType> fluid, Supplier<? extends LiquidBlock> block, Supplier<? extends Item> bucket, DeferredRegister<FluidType> FLUID_TYPES, DeferredRegister<Fluid> FLUIDS, int decrease) {
        this.TYPE = FLUID_TYPES.register(name + "_fluid", fluid);
        this.FLUID = FLUIDS.register(name + "_fluid", () -> new BaseFlowingFluid.Source(this.properties(block, bucket)));
        this.FLUID_FLOWING = FLUIDS.register(name + "_fluid_flowing", () -> new BaseFlowingFluid.Flowing(this.properties(block, bucket).levelDecreasePerBlock(decrease)));
    }

    public FluidRegistration(String name, Supplier<? extends FluidType> fluid, Supplier<? extends LiquidBlock> block, Supplier<? extends Item> bucket, DeferredRegister<FluidType> FLUID_TYPES, DeferredRegister<Fluid> FLUIDS, int decrease, int findSlope) {
        this.TYPE = FLUID_TYPES.register(name + "_fluid", fluid);
        this.FLUID = FLUIDS.register(name + "_fluid", () -> new BaseFlowingFluid.Source(this.properties(block, bucket)));
        this.FLUID_FLOWING = FLUIDS.register(name + "_fluid_flowing", () -> new BaseFlowingFluid.Flowing(this.properties(block, bucket).levelDecreasePerBlock(decrease).slopeFindDistance(findSlope)));
    }
}

