/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.gui;

import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.FancyTank;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FancyTankOutSlot
extends SlotItemHandler {
    FancyTank tank;

    public FancyTankOutSlot(IItemHandler itemHandler, FancyTank tank, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.tank = tank;
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.calcFluidOutSlotSize(stack);
    }

    private int calcFluidOutSlotSize(ItemStack pSlot) {
        if (pSlot.getCapability(Capabilities.FluidHandler.ITEM) != null && !pSlot.is(Items.BUCKET) && !pSlot.getCraftingRemainingItem().is(Items.BUCKET)) {
            return 1;
        }
        if (pSlot.getItem() == Items.BUCKET) {
            return this.tank.getFluidAmount(0) / 1000;
        }
        if (ItemStack.isSameItem((ItemStack)pSlot, (ItemStack)BottleFluidRegistry.getBottleFromFluid(this.tank.drain(250, IFluidHandler.FluidAction.SIMULATE)).getCraftingRemainingItem())) {
            return this.tank.getFluidAmount(0) / 250;
        }
        if (this.tank.drain(250, IFluidHandler.FluidAction.SIMULATE).is((Fluid)Fluids.WATER) && pSlot.is(Items.GLASS_BOTTLE)) {
            return this.tank.getFluidAmount(0) / 250;
        }
        return 0;
    }
}

