/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.integration.jei.categories;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.workstations.dryingrack.DryingRackRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DryingRackRecipeCategory
implements IRecipeCategory<DryingRackRecipe> {
    public static final RecipeType<DryingRackRecipe> TYPE = RecipeType.create((String)"extradelight", (String)"dryingrack", DryingRackRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public DryingRackRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/jei.png"), 0, 125, 85, 47);
        this.localizedName = Component.translatable((String)"extradelight.jei.dryingrack");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ExtraDelightItems.DRYING_RACK.get()));
    }

    public RecipeType<DryingRackRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DryingRackRecipe recipe, IFocusGroup focuses) {
        Ingredient input = recipe.getInput();
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        builder.addSlot(RecipeIngredientRole.INPUT, this.getWidth() / 2 - 38, 22).addIngredients(input);
        builder.addSlot(RecipeIngredientRole.OUTPUT, this.getWidth() / 2 + 13 + 9, 22).addItemStack(output);
    }
}

