/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.integration.jei.categories;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.mixingbowl.recipes.MixingBowlRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class MixingBowlRecipeCategory
implements IRecipeCategory<MixingBowlRecipe> {
    public static final RecipeType<MixingBowlRecipe> TYPE = RecipeType.create((String)"extradelight", (String)"mixingbowl", MixingBowlRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public MixingBowlRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/jei.png"), 109, 182, 147, 74);
        this.localizedName = Component.translatable((String)"extradelight.jei.mixingbowl");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ExtraDelightItems.MIXING_BOWL.get()));
    }

    public RecipeType<MixingBowlRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MixingBowlRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> input = recipe.getIngredients();
        Ingredient utensil = recipe.getUtensil();
        ItemStack container = recipe.getContainer();
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        int x = 0;
        int y = 0;
        for (Object i : input) {
            builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 47, y * 18 + 11).addIngredients((Ingredient)i);
            if (++x < 3) continue;
            ++y;
            x = 0;
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, this.getWidth() / 2 + 28, 12).addIngredients(utensil);
        builder.addSlot(RecipeIngredientRole.INPUT, this.getWidth() / 2 + 32, 52).addItemStack(container);
        builder.addSlot(RecipeIngredientRole.OUTPUT, this.getWidth() / 2 + 57, 29).addItemStack(output);
        int off = 0;
        for (SizedFluidIngredient i : recipe.getFluids()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, this.getWidth() / 2 - 49, 61 - off * 12).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(i.getFluids()))).setFluidRenderer((long)i.amount(), false, 16, 12);
            ++off;
        }
        if (recipe.getFluids().size() > 0) {
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.CATALYST, 1, 1);
            for (SizedFluidIngredient sfi : recipe.getFluids()) {
                for (FluidStack fs : sfi.getFluids()) {
                    slot.addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{BottleFluidRegistry.getBottleFromFluidWithoutSize(fs.getFluid()), new ItemStack((ItemLike)fs.getFluid().getBucket())}));
                }
            }
        }
    }

    public void draw(MixingBowlRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = minecraft.font;
        guiGraphics.drawString(fontRenderer, "x" + recipe.getStirs(), this.getWidth() / 2 + 44, 20, 0xFFFFFF);
        RenderSystem.disableBlend();
    }

    public static Vec2 getNextPointOnCircle(Vec2 center, Vec2 lastPoint, float angle) {
        double nextX = (double)center.x + 25.0 * Math.cos(Math.toRadians(angle));
        double nextY = (double)center.y + 25.0 * Math.sin(Math.toRadians(angle));
        return new Vec2((float)nextX, (float)nextY);
    }
}

