/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.integration.jei.categories;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightTags;
import com.lance5057.extradelight.workstations.mortar.recipes.MortarRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class MortarRecipeCategory
implements IRecipeCategory<MortarRecipe> {
    public static final RecipeType<MortarRecipe> TYPE = RecipeType.create((String)"extradelight", (String)"mortar", MortarRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public MortarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/jei.png"), 0, 0, 84, 52);
        this.localizedName = Component.translatable((String)"extradelight.jei.mortar");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ExtraDelightItems.MORTAR_STONE.get()));
    }

    public RecipeType<MortarRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MortarRecipe recipe, IFocusGroup focuses) {
        Ingredient input = (Ingredient)recipe.getIngredients().get(0);
        Ingredient pestle = Ingredient.of(ExtraDelightTags.PESTLES);
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        FluidStack outputFluid = recipe.getFluid();
        builder.addSlot(RecipeIngredientRole.INPUT, this.getWidth() / 2 - 39 + 6, 18).addIngredients(input);
        builder.addSlot(RecipeIngredientRole.CATALYST, this.getWidth() / 2 - 39 + 26, 1).addIngredients(pestle);
        builder.addSlot(RecipeIngredientRole.OUTPUT, this.getWidth() / 2 + 13 + 6, 26).addItemStack(output);
        if (recipe.getFluid() != null && !recipe.getFluid().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, this.getWidth() / 2 + 13 + 6, 8).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, List.of(recipe.getFluid()))).setFluidRenderer((long)recipe.getFluid().getAmount(), false, 16, 16);
        }
    }

    public void draw(MortarRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = minecraft.font;
        guiGraphics.drawString(fontRenderer, "x" + recipe.getGrinds(), this.getWidth() / 2 - 24 + 24, 8, 0xFFFFFF);
        RenderSystem.disableBlend();
    }
}

