/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.integration.patchouli.components;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CookingPotComponent
implements ICustomComponent {
    @SerializedName(value="recipe_name")
    public String recipeName;
    protected transient List<Ingredient> ingredients;
    protected transient int x;
    protected transient int y;
    private static final ResourceLocation POT_GRID = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/patchouli.png");

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX != -1 ? componentX : 17;
        this.y = componentY;
        this.ingredients = this.makeIngredients();
    }

    protected List<Ingredient> makeIngredients() {
        List recipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.COOKING.get());
        RecipeHolder recipe = recipes.stream().filter(r -> r.id().toString().equals(this.recipeName)).findFirst().orElse(null);
        if (recipe == null) {
            return ImmutableList.of();
        }
        return ((CookingPotRecipe)recipe.value()).getIngredients();
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider registries) {
        this.recipeName = ((IVariable)lookup.apply(IVariable.wrap((String)this.recipeName))).asString();
    }

    public void render(GuiGraphics graphics, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        graphics.pose().pushPose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)POT_GRID);
        RenderSystem.enableBlend();
        graphics.blit(POT_GRID, 22, 22, 86.0f, 0.0f, 76, 128, 256, 256);
        int x = 0;
        int y = 0;
        int xOff = 27;
        int yOff = 27;
        int size = 19;
        boolean count = false;
        for (Ingredient input : this.ingredients) {
            context.renderIngredient(graphics, xOff + x, yOff + y, mouseX, mouseY, input);
            if ((x += size) < size * 3) continue;
            x = 0;
            y += size;
        }
        graphics.pose().popPose();
    }
}

