/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.items.jar;

import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.util.RenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.renderable.BakedModelRenderable;
import net.neoforged.neoforge.client.model.renderable.IRenderable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class JarItemModel
extends BlockEntityWithoutLevelRenderer {
    private static JarItemModel instance;
    ModelResourceLocation rc = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"extra/jar"));
    IRenderable<ModelData> bm = BakedModelRenderable.of((ModelResourceLocation)this.rc).withModelDataContext();

    public JarItemModel(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
    }

    public static JarItemModel getInstance() {
        if (instance == null) {
            instance = new JarItemModel(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        }
        return instance;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack ps, MultiBufferSource mbs, int packedLight, int overlay) {
        if (stack.is((Item)ExtraDelightItems.JAR.get())) {
            ps.pushPose();
            if (displayContext == ItemDisplayContext.GUI) {
                ps.mulPose(new Quaternionf().rotateXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
                ps.translate(-0.05f, 1.0f, -1.9f);
                ps.scale(1.25f, 1.25f, 1.25f);
            } else if (displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                ps.translate(0.0, 0.35, (double)-0.17f);
            } else {
                ps.translate(0.0f, 0.25f, 0.0f);
            }
            this.bm.render(ps, mbs, texture -> RenderType.entityCutout((ResourceLocation)texture), packedLight, overlay, 0.0f, (Object)ModelData.EMPTY);
            VertexConsumer vertexConsumer = mbs.getBuffer(Sheets.translucentCullBlockSheet());
            Matrix4f mat = ps.last().pose();
            Matrix3f matrix3f = ps.last().normal();
            SimpleFluidContent f = (SimpleFluidContent)stack.get(ExtraDelightComponents.FLUID.get());
            if (f != null && !f.isEmpty()) {
                FluidStack fluidStack = f.copy();
                Fluid fluid = fluidStack.getFluid();
                IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                RenderUtil.buildCubeAll(new Vector3f(0.359375f, 0.03125f, 0.359375f), new Vector3f(0.3125f, (float)f.getAmount() / 1000.0f * 0.375f, 0.3125f), vertexConsumer, mat, matrix3f, fluidTypeExtensions.getTintColor(fluidStack), RenderUtil.getUV(fluidTypeExtensions.getStillTexture()), packedLight, overlay, ps);
            }
            ps.popPose();
        }
    }
}

