/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.recipe;

import com.lance5057.extradelight.ExtraDelight;
import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.items.dynamicfood.DynamicToast;
import com.lance5057.extradelight.items.dynamicfood.api.DynamicItemComponent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class DynamicToastRecipe
extends ShapelessRecipe {
    private final String graphic;

    public DynamicToastRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients, String graphic) {
        super(group, category, result, ingredients);
        this.graphic = graphic;
    }

    public String getGraphic() {
        return this.graphic;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack stack = super.getResultItem(registries).copy();
        if (stack.getItem() instanceof DynamicToast) {
            int nutrition = 0;
            float saturation = 0.0f;
            ArrayList effects = new ArrayList();
            NonNullList l = NonNullList.create();
            for (ItemStack s : input.items()) {
                if (s == null || s.isEmpty()) continue;
                l.add((Object)s);
                if (s.has(DataComponents.FOOD)) {
                    FoodProperties f = (FoodProperties)s.get(DataComponents.FOOD);
                    nutrition += f.nutrition();
                    saturation += f.saturation();
                    effects.addAll(f.effects());
                    continue;
                }
                ExtraDelight.logger.error(s.getDescriptionId() + " doesn't have a food component! How did we get here?!");
            }
            stack.set((DataComponentType)ExtraDelightComponents.DYNAMIC_FOOD.get(), (Object)new DynamicItemComponent(List.of(this.graphic)));
            stack.set((DataComponentType)ExtraDelightComponents.ITEMSTACK_HANDLER.get(), (Object)ItemContainerContents.fromItems((List)l));
            FoodProperties food = new FoodProperties(nutrition, saturation / (float)input.items().size(), false, 1.6f, Optional.empty(), effects);
            stack.set(DataComponents.FOOD, (Object)food);
        } else {
            ExtraDelight.logger.error("DynamicToastRecipe result not DynamicToast!");
        }
        return stack;
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.DYNAMIC_TOAST_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<DynamicToastRecipe> {
        public static final MapCodec<DynamicToastRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340778_ -> p_340778_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301133_ -> p_301133_.category()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.getResultItem(null)), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
            Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(p_300975_ -> p_300975_.getIngredients()), (App)Codec.STRING.optionalFieldOf("graphic", (Object)"").forGetter(DynamicToastRecipe::getGraphic)).apply((Applicative)p_340778_, DynamicToastRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DynamicToastRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<DynamicToastRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DynamicToastRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static DynamicToastRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            int i = buffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            String graphic = buffer.readUtf();
            return new DynamicToastRecipe(s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist, graphic);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, DynamicToastRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResultItem(null));
            buffer.writeUtf(recipe.getGraphic());
        }
    }
}

