/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.recipe;

import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.recipe.SimpleRecipeWrapper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FeastRecipe
implements Recipe<SimpleRecipeWrapper> {
    protected final String group;
    protected final BlockItem feast;
    protected final Ingredient container;
    protected final ItemStack result;
    final CookingBookCategory category = CookingBookCategory.FOOD;

    public Ingredient getContainer() {
        return this.container;
    }

    public FeastRecipe(String pGroup, BlockItem feast, Ingredient pIngredient, ItemStack pResult) {
        this.group = pGroup;
        this.feast = feast;
        this.container = pIngredient;
        this.result = pResult;
    }

    public FeastRecipe(String pGroup, ItemStack feast, Ingredient pIngredient, ItemStack pResult) {
        this.group = pGroup;
        this.feast = (BlockItem)feast.getItem();
        this.container = pIngredient;
        this.result = pResult;
    }

    public BlockItem getFeast() {
        return this.feast;
    }

    public ItemStack getFeastStack() {
        return new ItemStack((ItemLike)this.feast);
    }

    public boolean matches(SimpleRecipeWrapper pContainer, Level pLevel) {
        return this.container.test(pContainer.getItem(1)) && this.feast == pContainer.getItem(0).getItem();
    }

    public ItemStack assemble(SimpleRecipeWrapper input, HolderLookup.Provider registries) {
        return this.result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.FEAST_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ExtraDelightRecipes.FEAST.get();
    }

    public String getGroup() {
        return this.group;
    }

    public static class Serializer
    implements RecipeSerializer<FeastRecipe> {
        private static final MapCodec<FeastRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(FeastRecipe::getGroup), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("out").forGetter(r -> new ItemStack((ItemLike)r.feast)), (App)Ingredient.CODEC.fieldOf("container").forGetter(p_301068_ -> p_301068_.container), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result)).apply((Applicative)inst, FeastRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FeastRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static FeastRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer);
            BlockItem g = (BlockItem)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer)).getItem();
            return new FeastRecipe(s, g, ingredient, itemstack);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, FeastRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.container);
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result);
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)new ItemStack((ItemLike)pRecipe.getFeast()));
        }

        public MapCodec<FeastRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FeastRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

