/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.chiller;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightContainers;
import com.lance5057.extradelight.ExtraDelightTags;
import com.lance5057.extradelight.gui.FancyTankInSlot;
import com.lance5057.extradelight.gui.FancyTankOutSlot;
import com.lance5057.extradelight.workstations.FancyTank;
import com.lance5057.extradelight.workstations.chiller.ChillerBlockEntity;
import com.lance5057.extradelight.workstations.chiller.ChillerRecipe;
import com.lance5057.extradelight.workstations.chiller.ChillerRecipeWrapper;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ChillerMenu
extends RecipeBookMenu<ChillerRecipeWrapper, ChillerRecipe> {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BOWL = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"item/empty_container_slot_bowl");
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BUCKET = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"item/empty_container_slot_bucket");
    public final ChillerBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public ChillerMenu(int windowId, Inventory playerInventory, ChillerBlockEntity tileEntity) {
        super(ExtraDelightContainers.CHILLER_MENU.get(), windowId);
        int column;
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.level = playerInventory.player.level();
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        int startX = 8;
        int startY = 18;
        int inputStartX = 64;
        int inputStartY = 32;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (column = 0; column < 2; ++column) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, row * 2 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 5, 73, 68){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_CONTAINER_SLOT_BOWL);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 6, 126, 42){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        this.addSlot((Slot)new FancyTankInSlot(this, (IItemHandler)tileEntity.getItemHandler(), tileEntity.getFluidTank(), 7, 19, 13){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_CONTAINER_SLOT_BUCKET);
            }
        });
        this.addSlot((Slot)new FancyTankOutSlot((IItemHandler)tileEntity.getItemHandler(), tileEntity.getFluidTank(), 8, 19, 68));
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 9, 150, 68){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_CONTAINER_SLOT_BUCKET);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 10, 126, 10));
        int startPlayerInvY = startY * 4 + 30;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 160));
        }
    }

    public FancyTank getFluidTank() {
        return this.tileEntity.getFluidTank();
    }

    public FluidTank getDripTray() {
        return this.tileEntity.getDripTray();
    }

    private static ChillerBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof ChillerBlockEntity) {
            return (ChillerBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public ChillerMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, ChillerMenu.getTileEntity(playerInventory, data));
    }

    public boolean stillValid(Player playerIn) {
        return ChillerMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)ExtraDelightBlocks.CHILLER.get()));
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        int startPlayerInv = 10;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < startPlayerInv && !this.moveItemStackTo(itemstack1, startPlayerInv, endPlayerInv, true)) {
                return ItemStack.EMPTY;
            }
            if (index > 5) {
                if (itemstack1.is(ExtraDelightTags.TRAYS)) {
                    if (!this.moveItemStackTo(itemstack1, 4, 5, false)) {
                        return ItemStack.EMPTY;
                    }
                } else if (itemstack1.getCapability(Capabilities.FluidHandler.ITEM) != null) {
                    IFluidHandlerItem f = (IFluidHandlerItem)itemstack1.getCapability(Capabilities.FluidHandler.ITEM);
                    if (f.getFluidInTank(0).isEmpty()) {
                        if (!this.moveItemStackTo(itemstack1, 8, 9, false)) {
                            if (!this.moveItemStackTo(itemstack1, 7, 8, false)) {
                                return ItemStack.EMPTY;
                            }
                            return ItemStack.EMPTY;
                        }
                    } else if (!this.moveItemStackTo(itemstack1, 6, 7, false)) {
                        return ItemStack.EMPTY;
                    }
                } else if (!this.moveItemStackTo(itemstack1, 0, startPlayerInv, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void fillCraftSlotsStackedContents(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.accountSimpleStack(this.inventory.getStackInSlot(i));
        }
    }

    public void clearCraftingContent() {
        for (int i = 0; i < 12; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public int getResultSlotIndex() {
        return 11;
    }

    public int getGridWidth() {
        return 3;
    }

    public int getGridHeight() {
        return 3;
    }

    public int getSize() {
        return 10;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.valueOf((String)"EXTRADELIGHT_COOKING");
    }

    public boolean shouldMoveToInventory(int slot) {
        return slot < this.getGridWidth() * this.getGridHeight();
    }

    public boolean recipeMatches(RecipeHolder<ChillerRecipe> recipe) {
        return ((ChillerRecipe)recipe.value()).matches(new ChillerRecipeWrapper((IItemHandler)this.inventory, this.getFluidTank().getFluid()), this.level);
    }
}

