/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.chiller;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.workstations.chiller.ChillerRecipeWrapper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.fluids.FluidStack;

public class ChillerRecipe
implements Recipe<ChillerRecipeWrapper> {
    public static final int INPUT_SLOTS = 4;
    private final String group;
    private final NonNullList<Ingredient> inputItems;
    private final FluidStack fluid;
    public final ItemStack output;
    private final ItemStack container;
    private final float experience;
    private final int cookTime;
    public final boolean consumeContainer;

    public ChillerRecipe(String group, NonNullList<Ingredient> inputItems, FluidStack inputFluid, ItemStack output, ItemStack container, float experience, int cookTime) {
        this.group = group;
        this.fluid = inputFluid;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.isEmpty() ? container : ItemStack.EMPTY;
        this.experience = experience;
        this.cookTime = cookTime;
        this.consumeContainer = false;
    }

    public ChillerRecipe(String group, NonNullList<Ingredient> inputItems, FluidStack inputFluid, ItemStack output, ItemStack container, float experience, int cookTime, boolean consumeContainer) {
        this.group = group;
        this.fluid = inputFluid;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.isEmpty() ? container : ItemStack.EMPTY;
        this.experience = experience;
        this.cookTime = cookTime;
        this.consumeContainer = consumeContainer;
    }

    public ItemStack getContainerOverride() {
        return this.container;
    }

    public String getGroup() {
        return this.group;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputItems;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public ItemStack getOutputContainer() {
        return this.container;
    }

    public ItemStack assemble(ChillerRecipeWrapper input, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean shouldConsumeContainer() {
        return this.consumeContainer;
    }

    public boolean matches(ChillerRecipeWrapper inv, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++i;
            inputs.add(itemstack);
        }
        int[] matches = RecipeMatcher.findMatches(inputs, this.inputItems);
        return i == this.inputItems.size() && matches != null && inv.getItem(5).getItem() == this.container.getItem() && inv.getItem(5).getCount() >= this.container.getCount() && inv.tank.containsFluid(this.fluid);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.CHILLER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ExtraDelightRecipes.CHILLER.get();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ExtraDelightItems.CHILLER.get());
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public static class Serializer
    implements RecipeSerializer<ChillerRecipe> {
        private static final MapCodec<ChillerRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ChillerRecipe::getGroup), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").xmap(ingredients -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ingredients);
            return nonNullList;
        }, ingredients -> ingredients).forGetter(ChillerRecipe::getIngredients), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluid").forGetter(r -> r.fluid), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)ItemStack.CODEC.lenientOptionalFieldOf("container", (Object)ItemStack.EMPTY).forGetter(ChillerRecipe::getContainerOverride), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(ChillerRecipe::getExperience), (App)Codec.INT.lenientOptionalFieldOf("cookingtime", (Object)200).forGetter(ChillerRecipe::getCookTime), (App)Codec.BOOL.fieldOf("consumeContainer").forGetter(ChillerRecipe::shouldConsumeContainer)).apply((Applicative)inst, ChillerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ChillerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static ChillerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String groupIn = buffer.readUtf();
            int i = buffer.readVarInt();
            NonNullList inputItemsIn = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            FluidStack fluid = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            ItemStack outputIn = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            ItemStack container = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            float experienceIn = buffer.readFloat();
            int cookTimeIn = buffer.readVarInt();
            boolean consumeContainer = buffer.readBoolean();
            return new ChillerRecipe(groupIn, (NonNullList<Ingredient>)inputItemsIn, fluid, outputIn, container, experienceIn, cookTimeIn, consumeContainer);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, ChillerRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeVarInt(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluid);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.container);
            buffer.writeFloat(recipe.experience);
            buffer.writeVarInt(recipe.cookTime);
            buffer.writeBoolean(recipe.consumeContainer);
        }

        public MapCodec<ChillerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ChillerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

