/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.chiller;

import com.lance5057.extradelight.gui.widgets.FancyTankWidget;
import com.lance5057.extradelight.gui.widgets.FluidStackWidget;
import com.lance5057.extradelight.workstations.chiller.ChillerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ChillerScreen
extends AbstractContainerScreen<ChillerMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"textures/gui/chiller.png");
    private static final Rectangle HEAT_ICON = new Rectangle(176, 16, 12, 12);
    private static final Rectangle PROGRESS_ARROW = new Rectangle(176, 0, 22, 16);
    private boolean widthTooNarrow;

    public ChillerScreen(ChillerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void init() {
        super.init();
        this.titleLabelX = 28;
        this.addRenderableOnly((Renderable)new FancyTankWidget(this.leftPos + 43, this.topPos + 13, 16, 71, ((ChillerMenu)this.menu)::getFluidTank));
        this.addRenderableOnly((Renderable)new FluidStackWidget(this.leftPos + 126, this.topPos + 73, 16, 11, ((ChillerMenu)this.menu)::getDripTray));
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics ms, int mouseX, int mouseY) {
        ms.drawString(this.font, this.title, 8, this.imageHeight - 163, 0x404040, false);
        ms.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 20, 0x404040, false);
    }

    protected void renderBg(GuiGraphics ms, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.minecraft == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        ms.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight + 16);
        int l = ((ChillerMenu)this.menu).tileEntity.getCookTimeTotal();
        int m = ((ChillerMenu)this.menu).tileEntity.getCookTime();
        ms.blit(BACKGROUND_TEXTURE, this.leftPos + 101, this.topPos + 42, ChillerScreen.PROGRESS_ARROW.x, ChillerScreen.PROGRESS_ARROW.y, m != 0 && l != 0 ? m * 24 / l : 0, ChillerScreen.PROGRESS_ARROW.height);
        int n = ((ChillerMenu)this.menu).tileEntity.getChilltime();
        int o = ((ChillerMenu)this.menu).tileEntity.getChillDuration();
        int p = o != 0 && n != 0 ? -(n * 12 / o) : -ChillerScreen.HEAT_ICON.height;
        ms.blit(BACKGROUND_TEXTURE, this.leftPos + 128, this.topPos + 28 - p, ChillerScreen.HEAT_ICON.x, ChillerScreen.HEAT_ICON.y - p, ChillerScreen.HEAT_ICON.width, ChillerScreen.HEAT_ICON.height);
    }
}

