/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.doughshaping;

import com.lance5057.extradelight.workstations.doughshaping.DoughShapingMenu;
import com.lance5057.extradelight.workstations.doughshaping.recipes.DoughShapingRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DoughShapingScreen
extends AbstractContainerScreen<DoughShapingMenu> {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller_disabled");
    private static final ResourceLocation RECIPE_SELECTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe_selected");
    private static final ResourceLocation RECIPE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe_highlighted");
    private static final ResourceLocation RECIPE_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe");
    private static final ResourceLocation BG_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/stonecutter.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 52;
    private static final int RECIPES_Y = 14;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public DoughShapingScreen(DoughShapingMenu p_99310_, Inventory p_99311_, Component p_99312_) {
        super((AbstractContainerMenu)p_99310_, p_99311_, p_99312_);
        p_99310_.registerUpdateListener(this::containerChanged);
        --this.titleLabelY;
    }

    public void render(GuiGraphics p_281735_, int p_282517_, int p_282840_, float p_282389_) {
        super.render(p_281735_, p_282517_, p_282840_, p_282389_);
        this.renderTooltip(p_281735_, p_282517_, p_282840_);
    }

    protected void renderBg(GuiGraphics p_283115_, float p_282453_, int p_282940_, int p_282328_) {
        int i = this.leftPos;
        int j = this.topPos;
        p_283115_.blit(BG_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)(41.0f * this.scrollOffs);
        ResourceLocation resourcelocation = this.isScrollBarActive() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        p_283115_.blitSprite(resourcelocation, i + 119, j + 15 + k, 12, 15);
        int l = this.leftPos + 52;
        int i1 = this.topPos + 14;
        int j1 = this.startIndex + 12;
        this.renderButtons(p_283115_, p_282940_, p_282328_, l, i1, j1);
        this.renderRecipes(p_283115_, l, i1, j1);
    }

    protected void renderTooltip(GuiGraphics p_282396_, int p_283157_, int p_282258_) {
        super.renderTooltip(p_282396_, p_283157_, p_282258_);
        if (this.displayRecipes) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.startIndex + 12;
            List<RecipeHolder<DoughShapingRecipe>> list = ((DoughShapingMenu)this.menu).getRecipes();
            for (int l = this.startIndex; l < k && l < ((DoughShapingMenu)this.menu).getNumRecipes(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (p_283157_ < j1 || p_283157_ >= j1 + 16 || p_282258_ < k1 || p_282258_ >= k1 + 18) continue;
                p_282396_.renderTooltip(this.font, ((DoughShapingRecipe)list.get(l).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), p_283157_, p_282258_);
            }
        }
    }

    private void renderButtons(GuiGraphics p_282733_, int p_282136_, int p_282147_, int p_281987_, int p_281276_, int p_282688_) {
        for (int i = this.startIndex; i < p_282688_ && i < ((DoughShapingMenu)this.menu).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = p_281987_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_281276_ + l * 18 + 2;
            ResourceLocation resourcelocation = i == ((DoughShapingMenu)this.menu).getSelectedRecipeIndex() ? RECIPE_SELECTED_SPRITE : (p_282136_ >= k && p_282147_ >= i1 && p_282136_ < k + 16 && p_282147_ < i1 + 18 ? RECIPE_HIGHLIGHTED_SPRITE : RECIPE_SPRITE);
            p_282733_.blitSprite(resourcelocation, k, i1 - 1, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics p_281999_, int p_282658_, int p_282563_, int p_283352_) {
        List<RecipeHolder<DoughShapingRecipe>> list = ((DoughShapingMenu)this.menu).getRecipes();
        for (int i = this.startIndex; i < p_283352_ && i < ((DoughShapingMenu)this.menu).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = p_282658_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_282563_ + l * 18 + 2;
            p_281999_.renderItem(((DoughShapingRecipe)list.get(i).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), k, i1);
        }
    }

    public boolean mouseClicked(double p_99318_, double p_99319_, int p_99320_) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = p_99318_ - (double)(i + i1 % 4 * 16);
                double d1 = p_99319_ - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((DoughShapingMenu)this.menu).clickMenuButton((Player)this.minecraft.player, l)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.MAGMA_CUBE_SQUISH, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((DoughShapingMenu)this.menu).containerId, l);
                return true;
            }
            i = this.leftPos + 119;
            j = this.topPos + 9;
            if (p_99318_ >= (double)i && p_99318_ < (double)(i + 12) && p_99319_ >= (double)j && p_99319_ < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(p_99318_, p_99319_, p_99320_);
    }

    public boolean mouseDragged(double p_99322_, double p_99323_, int p_99324_, double p_99325_, double p_99326_) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 14;
            int j = i + 54;
            this.scrollOffs = ((float)p_99323_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(p_99322_, p_99323_, p_99324_, p_99325_, p_99326_);
    }

    public boolean mouseScrolled(double p_99314_, double p_99315_, double p_99316_, double p_295672_) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)p_295672_ / (float)i;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((DoughShapingMenu)this.menu).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((DoughShapingMenu)this.menu).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((DoughShapingMenu)this.menu).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

