/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.juicer;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.workstations.juicer.JuicerRecipe;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;

public class JuicerBlockEntity
extends SyncedBlockEntity
implements RecipeCraftingHolder {
    private int grinds = 0;
    public static final String INV_TAG = "inv";
    private final ItemStackHandler items = this.createHandler();
    private final Lazy<IItemHandlerModifiable> itemHandler = Lazy.of(() -> this.items);
    public static final int NUM_SLOTS = 1;
    public static final String FLUID_TAG = "fluid";
    private final FluidTank tank = this.createFluidHandler();

    private FluidTank createFluidHandler() {
        FluidTank tank = new FluidTank(4000){

            protected void onContentsChanged() {
                JuicerBlockEntity.this.requestModelDataUpdate();
                JuicerBlockEntity.this.getLevel().sendBlockUpdated(JuicerBlockEntity.this.getBlockPos(), JuicerBlockEntity.this.getBlockState(), JuicerBlockEntity.this.getBlockState(), 3);
                JuicerBlockEntity.this.setChanged();
            }
        };
        return tank;
    }

    public float getFullness() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public JuicerBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ExtraDelightBlockEntities.JUICER.get(), pPos, pState);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.itemHandler.get();
    }

    public FluidTank getFluidTank() {
        return this.tank;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 8;
            }

            protected void onContentsChanged(int slot) {
                JuicerBlockEntity.this.zeroProgress();
                JuicerBlockEntity.this.updateInventory();
            }
        };
    }

    public void insertItem(ItemStack stack) {
        Optional<RecipeHolder<JuicerRecipe>> recipeOptional = this.matchRecipe(stack);
        recipeOptional.ifPresent(r -> {
            BlockEntityUtils.Inventory.insertItem((IItemHandler)this.items, stack, 1);
            this.updateInventory();
        });
    }

    public void extractItem(Player p) {
        BlockEntityUtils.Inventory.extractItem(p, (IItemHandler)this.items, 1);
        this.updateInventory();
    }

    public void zeroProgress() {
        this.grinds = 0;
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public ItemStack getInsertedItem() {
        return this.items.getStackInSlot(0);
    }

    public int getGrind() {
        return this.grinds;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains(INV_TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(INV_TAG));
        }
        this.tank.readFromNBT(registries, nbt);
        this.grinds = nbt.getInt("Grinds");
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(INV_TAG, (Tag)this.items.serializeNBT(registries));
        this.tank.writeToNBT(registries, tag);
        tag.putInt("Grinds", this.grinds);
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }

    public Optional<RecipeHolder<JuicerRecipe>> matchRecipe(ItemStack itemstack) {
        if (this.level != null) {
            return this.level.getRecipeManager().getRecipeFor(ExtraDelightRecipes.JUICER.get(), (RecipeInput)new SingleRecipeInput(itemstack), this.level);
        }
        return Optional.empty();
    }

    public InteractionResult grind(Player Player2) {
        Optional<RecipeHolder<JuicerRecipe>> recipeOptional = this.matchRecipe(this.getInsertedItem());
        recipeOptional.ifPresent(r -> {
            JuicerRecipe recipe = (JuicerRecipe)r.value();
            if ((this.tank.isEmpty() || FluidStack.isSameFluid((FluidStack)recipe.getFluid(), (FluidStack)this.tank.getFluid())) && this.tank.fill(recipe.getFluid(), IFluidHandler.FluidAction.SIMULATE) == recipe.getFluid().getAmount()) {
                if (this.grinds + 1 < 8) {
                    ++this.grinds;
                    for (int i = 0; i < 1 + this.level.random.nextInt(4); ++i) {
                        this.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getInsertedItem()), (double)((float)this.worldPosition.getX() + 0.25f) + this.level.random.nextDouble() / 2.0, (double)((float)this.worldPosition.getY() + 0.5f) - this.level.random.nextDouble(), (double)((float)this.worldPosition.getZ() + 0.25f) + this.level.random.nextDouble() / 2.0, 0.0, 0.0, 0.0);
                    }
                    this.level.playSound(Player2, this.worldPosition, SoundEvents.STONE_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    ItemStack in = this.getInsertedItem();
                    for (int i = 0; i < in.getCount(); ++i) {
                        if (this.level.random.nextInt(100) < recipe.percentChance) {
                            ItemStack it = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy();
                            BlockEntityUtils.Inventory.dropItemInWorld(it, this.level, this.worldPosition);
                        }
                        this.tank.fill(recipe.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.items.setStackInSlot(0, ItemStack.EMPTY);
                }
                this.updateInventory();
            }
        });
        return InteractionResult.SUCCESS;
    }

    public void setRecipeUsed(RecipeHolder<?> p_300902_) {
    }

    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }
}

