/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.meltingpot;

import com.lance5057.extradelight.ExtraDelightRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class MeltingPotRecipe
implements Recipe<SingleRecipeInput> {
    final String group;
    public Ingredient input;
    public int cooktime;
    public FluidStack result;

    public MeltingPotRecipe(Ingredient in, int time, FluidStack out, String group) {
        this.group = group;
        this.input = in;
        this.cooktime = time;
        this.result = out;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.input.test(input.item());
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)Items.STICK);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)Items.STICK);
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.MELTING_POT_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ExtraDelightRecipes.MELTING_POT.get();
    }

    public String getGroup() {
        return this.group;
    }

    public static class Serializer
    implements RecipeSerializer<MeltingPotRecipe> {
        private static final MapCodec<MeltingPotRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> r.input), (App)Codec.INT.optionalFieldOf("cooktime", (Object)100).forGetter(r -> r.cooktime), (App)FluidStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(MeltingPotRecipe::getGroup)).apply((Applicative)inst, MeltingPotRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MeltingPotRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static MeltingPotRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            int cooktime = pBuffer.readVarInt();
            FluidStack usedItem = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
            return new MeltingPotRecipe(ingredient, cooktime, usedItem, s);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, MeltingPotRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.input);
            pBuffer.writeVarInt(pRecipe.cooktime);
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result);
        }

        public MapCodec<MeltingPotRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MeltingPotRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

