/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.mixingbowl;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightFluids;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.modules.SummerCitrus;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.FancyTank;
import com.lance5057.extradelight.workstations.IFancyTankHandler;
import com.lance5057.extradelight.workstations.mixingbowl.recipes.MixingBowlRecipe;
import com.lance5057.extradelight.workstations.mixingbowl.recipes.MixingBowlRecipeWrapper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MixingBowlBlockEntity
extends BlockEntity
implements IFancyTankHandler<MixingBowlBlockEntity> {
    public static final String INV_TAG = "inv";
    private final ItemStackHandler items = this.createHandler();
    private final Lazy<IItemHandlerModifiable> itemHandler = Lazy.of(() -> this.items);
    public static final int CRAFT_SLOTS = 8;
    public static final int CONTAINER_SLOT = 9;
    public static final int LIQUID_IN_SLOT = 10;
    public static final int LIQUID_OUT_SLOT = 11;
    public static final int GHOST_SLOT = 12;
    public static final int GHOST_UTENSIL_SLOT = 13;
    public static final int INVENTORY_SIZE = 14;
    public static final String FLUID_TAG = "tank";
    private final FancyTank fluids = this.createFluidHandler();
    private int stirs = 0;
    public boolean complete = false;
    public ItemStack containerItem = ItemStack.EMPTY;
    MixingBowlRecipe curRecipe;

    @Override
    public int getFluidInSlot() {
        return 10;
    }

    @Override
    public int getFluidOutSlot() {
        return 11;
    }

    public MixingBowlBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ExtraDelightBlockEntities.MIXING_BOWL.get(), pPos, pState);
    }

    private FancyTank createFluidHandler() {
        FancyTank tank = new FancyTank(6000){

            @Override
            protected void onContentsChanged() {
                super.onContentsChanged();
                Level level = MixingBowlBlockEntity.this.getLevel();
                if (level == null) {
                    return;
                }
                MixingBowlBlockEntity.this.requestModelDataUpdate();
                level.sendBlockUpdated(MixingBowlBlockEntity.this.getBlockPos(), MixingBowlBlockEntity.this.getBlockState(), MixingBowlBlockEntity.this.getBlockState(), 3);
                MixingBowlBlockEntity.this.setChanged();
            }
        };
        return tank;
    }

    @Override
    public FancyTank getFluidTank() {
        return this.fluids;
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.itemHandler.get();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(14){

            public boolean isItemValid(int slot, ItemStack stack) {
                switch (slot) {
                    case 10: {
                        return stack.getCapability(Capabilities.FluidHandler.ITEM) != null || stack.is(Items.BUCKET) || !BottleFluidRegistry.getFluidFromBottle(stack).isEmpty();
                    }
                    case 11: {
                        return stack.getCapability(Capabilities.FluidHandler.ITEM) != null || stack.is(Items.BUCKET) || ItemStack.isSameItem((ItemStack)stack, (ItemStack)BottleFluidRegistry.getBottleFromFluid(MixingBowlBlockEntity.this.getFluidTank().drain(250, IFluidHandler.FluidAction.SIMULATE)).getCraftingRemainingItem()) || stack.is(Items.GLASS_BOTTLE);
                    }
                    case 12: 
                    case 13: {
                        return false;
                    }
                }
                return true;
            }

            protected void onContentsChanged(int slot) {
                if (slot != 12 && slot != 13) {
                    MixingBowlBlockEntity.this.zeroProgress();
                    MixingBowlBlockEntity.this.updateInventory();
                }
                if (slot == 10) {
                    MixingBowlBlockEntity.this.fillInternal(MixingBowlBlockEntity.this);
                }
                if (slot == 11) {
                    MixingBowlBlockEntity.this.drainInternal(MixingBowlBlockEntity.this);
                }
            }
        };
    }

    private boolean doesMealHaveContainer(ItemStack meal) {
        return meal.hasCraftingRemainingItem();
    }

    public int getLastFilledSlot(IItemHandlerModifiable inventory) {
        if (inventory.getStackInSlot(9) != ItemStack.EMPTY) {
            return 9;
        }
        for (int i = 0; i <= 9; ++i) {
            if (inventory.getStackInSlot(i) != ItemStack.EMPTY) continue;
            return i - 1;
        }
        return -1;
    }

    public void extractItem(Player playerEntity, IItemHandlerModifiable inventory) {
        int i = this.getLastFilledSlot(inventory);
        if (i != -1) {
            ItemStack itemStack = inventory.extractItem(i, 1, false);
            playerEntity.addItem(itemStack);
            this.updateInventory();
            return;
        }
        this.updateInventory();
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack slotStack = this.items.getStackInSlot(i);
            if (!slotStack.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public void zeroProgress() {
        this.stirs = 0;
    }

    @Override
    public void updateInventory() {
        this.setupRecipe();
        this.requestModelDataUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    private void setupRecipe() {
        Optional<RecipeHolder<MixingBowlRecipe>> recipe = this.matchRecipe();
        if (recipe.isPresent()) {
            this.curRecipe = (MixingBowlRecipe)recipe.get().value();
            this.items.setStackInSlot(12, this.curRecipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy());
            this.items.setStackInSlot(13, this.curRecipe.getUtensil().getItems()[this.level.random.nextInt(this.curRecipe.getUtensil().getItems().length)]);
        } else {
            this.curRecipe = null;
            this.items.setStackInSlot(12, ItemStack.EMPTY.copy());
            this.items.setStackInSlot(13, ItemStack.EMPTY.copy());
        }
    }

    public int getStirs() {
        return this.stirs;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains(INV_TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(INV_TAG));
        }
        this.getFluidTank().readFromNBT(registries, nbt);
        this.stirs = nbt.getInt("stirs");
        if (nbt.contains("container")) {
            ItemStack.parse((HolderLookup.Provider)registries, (Tag)nbt.getCompound("container")).ifPresent(i -> {
                this.containerItem = i;
            });
        }
        this.complete = nbt.getBoolean("complete");
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(INV_TAG, (Tag)this.items.serializeNBT(registries));
        this.getFluidTank().writeToNBT(registries, tag);
        tag.putInt("stirs", this.stirs);
        if (!this.containerItem.isEmpty()) {
            tag.put("container", this.containerItem.saveOptional(registries));
        }
        tag.putBoolean("complete", this.complete);
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }

    private ItemStack[] getItems() {
        int s = this.getLastFilledSlot((IItemHandlerModifiable)this.items);
        if (s != -1) {
            ItemStack[] stacks = new ItemStack[s + 1];
            for (int i = 0; i < s + 1; ++i) {
                stacks[i] = this.items.getStackInSlot(i);
            }
            return stacks;
        }
        return new ItemStack[0];
    }

    private void clearItems(int k) {
        for (int i = 0; i < 9; ++i) {
            if (this.items.getStackInSlot(i).isEmpty()) continue;
            this.items.extractItem(i, 1, false);
        }
        if (!this.items.getStackInSlot(9).isEmpty()) {
            this.items.extractItem(9, k, false);
        }
    }

    protected Optional<RecipeHolder<MixingBowlRecipe>> matchRecipe() {
        if (this.level != null) {
            Optional recipe = this.level.getRecipeManager().getRecipeFor(ExtraDelightRecipes.MIXING_BOWL.get(), (RecipeInput)new MixingBowlRecipeWrapper(this, (IItemHandler)this.items, this.fluids){

                public int size() {
                    return 9;
                }

                public boolean isEmpty() {
                    boolean res = true;
                    if (this.getTank().getTotalAmount() != 0) {
                        return false;
                    }
                    for (int i = 0; i < this.inv.getSlots(); ++i) {
                        if (this.inv.getStackInSlot(i).isEmpty()) continue;
                        res = false;
                        break;
                    }
                    return res;
                }
            }, this.level);
            return recipe;
        }
        return Optional.empty();
    }

    public InteractionResult mix(Player player, ItemStack utensil) {
        if (this.curRecipe != null && this.curRecipe.getUtensil().test(utensil)) {
            if (this.stirs < this.curRecipe.getStirs()) {
                ++this.stirs;
                this.level.playSound(player, this.worldPosition, SoundEvents.STONE_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                this.containerItem = this.curRecipe.getContainer().copy();
                ItemStack i = this.curRecipe.getResultItem((HolderLookup.Provider)player.level().registryAccess()).copy();
                int k = i.getCount();
                List<SizedFluidIngredient> fl = this.curRecipe.getFluids();
                i.onCraftedBy(player.level(), player, 1);
                BlockEntityUtils.Inventory.givePlayerItemStack(i, player, this.level, this.worldPosition);
                this.dropContainers((IItemHandlerModifiable)this.items, player);
                this.clearItems(k);
                this.removeFluids(fl);
                this.stirs = 0;
                this.complete = true;
            }
            this.updateInventory();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void removeFluids(List<SizedFluidIngredient> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.fluids.drain(list.get(i), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public boolean testContainerItem(ItemStack stack) {
        if (this.containerItem.isEmpty()) {
            return true;
        }
        return this.containerItem.getItem() == stack.getItem();
    }

    private void dropContainers(@NotNull IItemHandlerModifiable inv, Player player) {
        for (int i = 0; i < 9; ++i) {
            BlockEntityUtils.Inventory.givePlayerItemStack(inv.getStackInSlot(i).getCraftingRemainingItem().copy(), player, this.level, this.worldPosition);
        }
    }

    public ItemInteractionResult handleEgg(Player pPlayer, ItemStack stack) {
        if (this.getFluidTank().fill(new FluidStack(ExtraDelightFluids.EGG_WHITE.FLUID, 250), IFluidHandler.FluidAction.SIMULATE) == 250) {
            BlockEntityUtils.Inventory.givePlayerItemStack(new ItemStack((ItemLike)SummerCitrus.EGG_YOLK.get()), pPlayer, this.level, this.worldPosition);
            this.getFluidTank().fill(new FluidStack(ExtraDelightFluids.EGG_WHITE.FLUID, 250), IFluidHandler.FluidAction.EXECUTE);
            stack.shrink(1);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.CONSUME;
    }
}

