/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.mixingbowl.recipes;

import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.workstations.mixingbowl.recipes.MixingBowlRecipeWrapper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class MixingBowlRecipe
implements Recipe<MixingBowlRecipeWrapper> {
    protected final int stirs;
    final ItemStack container;
    final Ingredient utensil;
    final String group;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;
    final List<SizedFluidIngredient> fluids;

    public MixingBowlRecipe(String pGroup, NonNullList<Ingredient> pIngredients, List<SizedFluidIngredient> pFluids, ItemStack pResult, int stirs, ItemStack container, Ingredient utensil) {
        this.stirs = stirs;
        this.container = container;
        this.utensil = utensil;
        this.group = pGroup;
        this.result = pResult;
        this.ingredients = pIngredients;
        this.fluids = pFluids;
    }

    public String getGroup() {
        return this.group;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public List<SizedFluidIngredient> getFluids() {
        return this.fluids;
    }

    public boolean matches(MixingBowlRecipeWrapper input, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            ItemStack itemstack = input.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++i;
            inputs.add(itemstack);
        }
        boolean itemMatchFlag = this.ingredients == null || this.ingredients.isEmpty() || ItemStack.isSameItem((ItemStack)((Ingredient)this.ingredients.get(0)).getItems()[0], (ItemStack)ItemStack.EMPTY) ? i == 0 : i == this.ingredients.size() && RecipeMatcher.findMatches(inputs, this.ingredients) != null;
        return itemMatchFlag && this.matchFluids(input.getTank().getAsList()) && ItemStack.isSameItem((ItemStack)this.container, (ItemStack)input.getItem(9)) && input.getItem(9).getCount() >= this.container.getCount();
    }

    boolean matchFluids(List<FluidStack> f) {
        int count = 0;
        for (int i = 0; i < this.fluids.size(); ++i) {
            for (int j = 0; j < f.size(); ++j) {
                FluidStack f2;
                SizedFluidIngredient f1 = this.fluids.get(i);
                if (!f1.test(f2 = f.get(j))) continue;
                ++count;
            }
        }
        return count == this.fluids.size();
    }

    public ItemStack assemble(SimpleContainer pInv, RegistryAccess p_267165_) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= this.ingredients.size();
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.MIXING_BOWL_SERIALIZER.get();
    }

    public int getStirs() {
        return this.stirs;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public Ingredient getUtensil() {
        return this.utensil;
    }

    public ItemStack assemble(MixingBowlRecipeWrapper input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeType<?> getType() {
        return ExtraDelightRecipes.MIXING_BOWL.get();
    }

    public static class Serializer
    implements RecipeSerializer<MixingBowlRecipe> {
        private static final MapCodec<MixingBowlRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(MixingBowlRecipe::getGroup), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").xmap(ing -> {
            NonNullList nonNullList = NonNullList.create();
            if (!ing.isEmpty()) {
                nonNullList.addAll((Collection)ing);
            }
            return nonNullList;
        }, ing -> ing).forGetter(MixingBowlRecipe::getIngredients), (App)SizedFluidIngredient.FLAT_CODEC.listOf().fieldOf("fluids").forGetter(MixingBowlRecipe::getFluids), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.optionalFieldOf("stirs", (Object)100).forGetter(r -> r.stirs), (App)ItemStack.CODEC.optionalFieldOf("container", (Object)ItemStack.EMPTY).forGetter(r -> r.container), (App)Ingredient.CODEC.fieldOf("utensil").forGetter(r -> r.utensil)).apply((Applicative)inst, MixingBowlRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MixingBowlRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static MixingBowlRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            int i = pBuffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer)));
            }
            int f = pBuffer.readVarInt();
            ArrayList<SizedFluidIngredient> fl = new ArrayList<SizedFluidIngredient>();
            for (int h = 0; h < f; ++h) {
                fl.add(h, (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)pBuffer));
            }
            ItemStack itemstack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
            int stirs = pBuffer.readVarInt();
            ItemStack container = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
            Ingredient utensil = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            return new MixingBowlRecipe(s, (NonNullList<Ingredient>)nonnulllist, fl, itemstack, stirs, container, utensil);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, MixingBowlRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.getGroup());
            pBuffer.writeVarInt(pRecipe.getIngredients().size());
            for (Ingredient ingredient : pRecipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)ingredient);
            }
            pBuffer.writeVarInt(pRecipe.getFluids().size());
            for (SizedFluidIngredient f : pRecipe.getFluids()) {
                SizedFluidIngredient.STREAM_CODEC.encode((Object)pBuffer, (Object)f);
            }
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result);
            pBuffer.writeVarInt(pRecipe.getStirs());
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.getContainer());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.utensil);
        }

        public MapCodec<MixingBowlRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MixingBowlRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

