/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.oven.recipes;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class OvenRecipe
implements Recipe<RecipeWrapper> {
    public static final int INPUT_SLOTS = 9;
    private final String group;
    private final NonNullList<Ingredient> inputItems;
    public final ItemStack output;
    private final ItemStack container;
    private final float experience;
    private final int cookTime;
    private final boolean consumeContainer;

    public OvenRecipe(String group, NonNullList<Ingredient> inputItems, ItemStack output, ItemStack container, float experience, int cookTime, boolean consumeContainer) {
        this.group = group;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.isEmpty() ? container : ItemStack.EMPTY;
        this.experience = experience;
        this.cookTime = cookTime;
        this.consumeContainer = consumeContainer;
    }

    public ItemStack getContainerOverride() {
        return this.container;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean shouldConsumeContainer() {
        return this.consumeContainer;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputItems;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output;
    }

    public ItemStack getOutputContainer() {
        return this.container;
    }

    public ItemStack assemble(RecipeWrapper input, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null && inv.getItem(10).getItem() == this.container.getItem();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.OVEN_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ExtraDelightRecipes.OVEN.get();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ExtraDelightItems.OVEN.get());
    }

    public static class Serializer
    implements RecipeSerializer<OvenRecipe> {
        private static final MapCodec<OvenRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(OvenRecipe::getGroup), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").xmap(ingredients -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ingredients);
            return nonNullList;
        }, ingredients -> ingredients).forGetter(OvenRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)ItemStack.CODEC.lenientOptionalFieldOf("container", (Object)ItemStack.EMPTY).forGetter(OvenRecipe::getContainerOverride), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(OvenRecipe::getExperience), (App)Codec.INT.lenientOptionalFieldOf("cookingtime", (Object)200).forGetter(OvenRecipe::getCookTime), (App)Codec.BOOL.fieldOf("consumeContainer").forGetter(OvenRecipe::shouldConsumeContainer)).apply((Applicative)inst, OvenRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, OvenRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static OvenRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String groupIn = buffer.readUtf();
            int i = buffer.readVarInt();
            NonNullList inputItemsIn = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            ItemStack outputIn = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            ItemStack container = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            float experienceIn = buffer.readFloat();
            int cookTimeIn = buffer.readVarInt();
            boolean consume = buffer.readBoolean();
            return new OvenRecipe(groupIn, (NonNullList<Ingredient>)inputItemsIn, outputIn, container, experienceIn, cookTimeIn, consume);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, OvenRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeVarInt(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.container);
            buffer.writeFloat(recipe.experience);
            buffer.writeVarInt(recipe.cookTime);
            buffer.writeBoolean(recipe.consumeContainer);
        }

        public MapCodec<OvenRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, OvenRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

