/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.workstations.vat.recipes;

import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.workstations.vat.recipes.VatRecipeWrapper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class VatRecipe
implements Recipe<VatRecipeWrapper> {
    final ItemStack containerItem;
    final String group;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;
    final NonNullList<StageIngredient> stageIngredients;
    final SizedFluidIngredient fluid;
    protected final int stages;

    public int getStages() {
        return this.stages;
    }

    public VatRecipe(String pGroup, NonNullList<Ingredient> pIngredients, NonNullList<StageIngredient> pStageIngredients, SizedFluidIngredient pFluids, ItemStack pResult, int stages, ItemStack usedItem) {
        this.containerItem = usedItem;
        this.group = pGroup;
        this.result = pResult;
        this.ingredients = pIngredients;
        this.stageIngredients = pStageIngredients;
        this.fluid = pFluids;
        this.stages = stages;
    }

    public String getGroup() {
        return this.group;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public NonNullList<StageIngredient> getStageIngredients() {
        return this.stageIngredients;
    }

    public SizedFluidIngredient getFluid() {
        return this.fluid;
    }

    public boolean matches(VatRecipeWrapper input, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 6; ++j) {
            ItemStack itemstack = input.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && RecipeMatcher.findMatches(inputs, this.ingredients) != null && this.fluid.test(input.getTank().getFluid()) && ItemStack.isSameItem((ItemStack)this.containerItem, (ItemStack)input.getItem(6)) && input.getItem(6).getCount() >= this.containerItem.getCount();
    }

    public ItemStack assemble(SimpleContainer pInv, RegistryAccess p_267165_) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= this.ingredients.size();
    }

    public RecipeSerializer<?> getSerializer() {
        return ExtraDelightRecipes.VAT_SERIALIZER.get();
    }

    public ItemStack getUsedItem() {
        return this.containerItem;
    }

    public ItemStack assemble(VatRecipeWrapper input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeType<?> getType() {
        return ExtraDelightRecipes.VAT.get();
    }

    public static class Serializer
    implements RecipeSerializer<VatRecipe> {
        private static final MapCodec<VatRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(VatRecipe::getGroup), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").xmap(ing -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ing);
            return nonNullList;
        }, ing -> ing).forGetter(VatRecipe::getIngredients), (App)Codec.list(StageIngredient.CODEC).fieldOf("stage_ingredients").xmap(ing -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ing);
            return nonNullList;
        }, ing -> ing).forGetter(VatRecipe::getStageIngredients), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluids").forGetter(VatRecipe::getFluid), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.fieldOf("stages").forGetter(r -> r.stages), (App)ItemStack.CODEC.optionalFieldOf("usedItem", (Object)ItemStack.EMPTY).forGetter(r -> r.containerItem)).apply((Applicative)inst, VatRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, VatRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static VatRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String s = pBuffer.readUtf();
            int i = pBuffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer)));
            }
            int x = pBuffer.readVarInt();
            NonNullList nonnulllist2 = NonNullList.withSize((int)x, (Object)StageIngredient.EMPTY);
            for (int j = 0; j < nonnulllist2.size(); ++j) {
                nonnulllist2.set(j, (Object)((StageIngredient)StageIngredient.STREAM_CODEC.decode((Object)pBuffer)));
            }
            SizedFluidIngredient f = (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)pBuffer);
            ItemStack itemstack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
            int stages = pBuffer.readVarInt();
            ItemStack usedItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
            return new VatRecipe(s, (NonNullList<Ingredient>)nonnulllist, (NonNullList<StageIngredient>)nonnulllist2, f, itemstack, stages, usedItem);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, VatRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.getGroup());
            pBuffer.writeVarInt(pRecipe.getIngredients().size());
            for (Object ingredient : pRecipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, ingredient);
            }
            pBuffer.writeVarInt(pRecipe.stageIngredients.size());
            for (Object ingredient : pRecipe.stageIngredients) {
                StageIngredient.STREAM_CODEC.encode((Object)pBuffer, ingredient);
            }
            SizedFluidIngredient.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.getFluid());
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result);
            pBuffer.writeVarInt(pRecipe.getStages());
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.getUsedItem());
        }

        public MapCodec<VatRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, VatRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class StageIngredient {
        public static final StageIngredient EMPTY = new StageIngredient(Ingredient.EMPTY, 0, false);
        public Ingredient ingredient;
        public int time;
        public boolean lid;
        public static Codec<StageIngredient> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(s -> s.ingredient), (App)Codec.INT.fieldOf("time").forGetter(s -> s.time), (App)Codec.BOOL.fieldOf("lid").forGetter(s -> s.lid)).apply((Applicative)inst, StageIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, StageIngredient> STREAM_CODEC = StreamCodec.of(StageIngredient::write, StageIngredient::read);

        public StageIngredient(Ingredient i, int t, boolean l) {
            this.ingredient = i;
            this.time = t;
            this.lid = l;
        }

        private static StageIngredient read(RegistryFriendlyByteBuf buffer) {
            Ingredient i = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int t = buffer.readVarInt();
            boolean l = buffer.readBoolean();
            return new StageIngredient(i, t, l);
        }

        private static void write(RegistryFriendlyByteBuf buffer, StageIngredient r) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)r.ingredient);
            buffer.writeVarInt(r.time);
            buffer.writeBoolean(r.lid);
        }
    }
}

