/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.worldgen.features;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.blocks.crops.corn.CornBottom;
import com.lance5057.extradelight.util.EllersGen;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class CornMazeFeature
extends Feature<SimpleBlockConfiguration> {
    List<Block> expected = Arrays.asList((Block)ExtraDelightBlocks.CORN_BOTTOM.get(), Blocks.AIR);

    public CornMazeFeature() {
        super(SimpleBlockConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> pContext) {
        SimpleBlockConfiguration simpleblockconfiguration = (SimpleBlockConfiguration)pContext.config();
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        int cx = worldgenlevel.getChunk(blockpos).getPos().getMinBlockX();
        int cz = worldgenlevel.getChunk(blockpos).getPos().getMinBlockZ();
        blockpos = new BlockPos(cx, blockpos.getY(), cz);
        BlockState blockstate = simpleblockconfiguration.toPlace().getState(pContext.random(), blockpos);
        int h = 18;
        int w = 18;
        EllersGen maze = new EllersGen(h, w);
        maze.makeMaze();
        char[][] m = maze.getMaze();
        for (int x = 1; x < w - 1; ++x) {
            for (int z = 1; z < h - 1; ++z) {
                if (!blockstate.canSurvive((LevelReader)worldgenlevel, blockpos) || !(blockstate.getBlock() instanceof CornBottom)) continue;
                BlockPos p = new BlockPos(blockpos.getX() + x - 1, blockpos.getY(), blockpos.getZ() + z - 1);
                if (m[x][z] != '#' || !this.checkAround(worldgenlevel, p, 5)) continue;
                CornBottom.placeAt((LevelAccessor)worldgenlevel, blockstate, p, 0);
            }
        }
        return true;
    }

    boolean checkAround(WorldGenLevel level, BlockPos pos, int size) {
        for (int x = -size; x < size + 1; ++x) {
            for (int z = -size; z < size + 1; ++z) {
                BlockPos p = new BlockPos(pos.getX() + x, pos.getY(), pos.getZ() + z);
                Block b = level.getBlockState(p).getBlock();
                if (this.expected.contains(b)) continue;
                return false;
            }
        }
        return true;
    }
}

