/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.worldgen.features;

import com.lance5057.extradelight.ExtraDelight;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;

public class CornMazeRail
extends Feature<SimpleBlockConfiguration> {
    public CornMazeRail() {
        super(SimpleBlockConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> pContext) {
        SimpleBlockConfiguration config = (SimpleBlockConfiguration)pContext.config();
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        int cx = worldgenlevel.getChunk(blockpos).getPos().getMinBlockX();
        int cz = worldgenlevel.getChunk(blockpos).getPos().getMinBlockZ();
        blockpos = new BlockPos(cx, blockpos.getY(), cz);
        if (cz == 0) {
            int z = worldgenlevel.getChunk((BlockPos)blockpos).getPos().x;
            if (z % 100 == 0) {
                this.spawnStop(worldgenlevel, new BlockPos(cx, blockpos.getY() - 1, cz));
            } else {
                for (int i = 0; i < 16; ++i) {
                    BlockPos p = new BlockPos(blockpos.getX() + i, blockpos.getY(), blockpos.getZ() + 8);
                    for (int j = -1; j < 2; ++j) {
                        BlockPos p2 = new BlockPos(blockpos.getX() + i, blockpos.getY() - 1, blockpos.getZ() + j + 8);
                        worldgenlevel.setBlock(p2, Blocks.GRAVEL.defaultBlockState(), 2);
                    }
                    worldgenlevel.setBlock(p, (BlockState)Blocks.RAIL.defaultBlockState().setValue((Property)RailBlock.SHAPE, (Comparable)RailShape.EAST_WEST), 0);
                    worldgenlevel.setBlock(new BlockPos(blockpos.getX() + i, blockpos.getY(), blockpos.getZ() + 12), (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue((Property)FenceBlock.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)FenceBlock.WEST, (Comparable)Boolean.valueOf(true)), 3);
                    worldgenlevel.setBlock(new BlockPos(blockpos.getX() + i, blockpos.getY(), blockpos.getZ() + 4), (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue((Property)FenceBlock.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)FenceBlock.WEST, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
            return true;
        }
        return false;
    }

    void spawnStop(WorldGenLevel level, BlockPos pos) {
        Optional structure = level.getServer().getStructureManager().get(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"rail_stop"));
        if (structure.isEmpty()) {
            ExtraDelight.logger.error(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)"rail_stop").toString() + " not found!");
        }
        structure.ifPresent(s -> {
            BlockPos pos2 = s.getZeroPositionWithTransform(pos, Mirror.NONE, Rotation.NONE);
            s.placeInWorld((ServerLevelAccessor)level, pos, pos2, new StructurePlaceSettings(), level.getRandom(), 4);
        });
    }
}

