/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.worldgen.features.crops;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.blocks.crops.corn.CornBottom;
import com.lance5057.extradelight.blocks.crops.corn.CornTop;
import com.lance5057.extradelight.worldgen.config.WildConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class WildCornFeature
extends Feature<WildConfig> {
    public WildCornFeature() {
        super(WildConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<WildConfig> pContext) {
        WildConfig WildCornConfig = (WildConfig)pContext.config();
        RandomSource randomsource = pContext.random();
        BlockPos blockpos = pContext.origin();
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int j = WildCornConfig.xzSpread() + 1;
        int k = WildCornConfig.ySpread() + 1;
        int generated = 0;
        int maxCount = randomsource.nextIntBetweenInclusive(WildCornConfig.minCount(), WildCornConfig.maxCount());
        for (int tryCount = 0; tryCount < WildCornConfig.tries() && generated < maxCount; ++tryCount) {
            pos.setWithOffset((Vec3i)blockpos, randomsource.nextInt(j) - randomsource.nextInt(j), randomsource.nextInt(k) - randomsource.nextInt(k), randomsource.nextInt(j) - randomsource.nextInt(j));
            if (!worldgenlevel.isEmptyBlock((BlockPos)pos) && !worldgenlevel.getBlockState((BlockPos)pos).is(BlockTags.SNOW) || !((CornBottom)((Object)ExtraDelightBlocks.CORN_BOTTOM.get())).canSurvive(worldgenlevel.getBlockState((BlockPos)pos), (LevelReader)worldgenlevel, (BlockPos)pos)) continue;
            this.spawn((LevelAccessor)worldgenlevel, randomsource, (BlockPos)pos);
            ++generated;
        }
        return generated > 0;
    }

    private List<BlockPos> getAdjacentBlocks(BlockPos blockpos) {
        return new ArrayList<BlockPos>(Arrays.asList(blockpos.east(), blockpos.west(), blockpos.north(), blockpos.south(), blockpos.north().east(), blockpos.north().west(), blockpos.south().east(), blockpos.south().west()));
    }

    private void spawn(LevelAccessor worldIn, RandomSource rand, BlockPos generatingPos) {
        worldIn.setBlock(generatingPos.above(), (BlockState)((CornTop)((Object)ExtraDelightBlocks.CORN_TOP.get())).defaultBlockState().setValue((Property)CornTop.AGE, (Comparable)Integer.valueOf(3)), 2);
        worldIn.setBlock(generatingPos, (BlockState)((CornBottom)((Object)ExtraDelightBlocks.CORN_BOTTOM.get())).defaultBlockState().setValue((Property)CornBottom.AGE, (Comparable)Integer.valueOf(3)), 2);
    }
}

