/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome.sub;

import com.mojang.serialization.MapCodec;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.api.biome.sub.BiomeParameterTargets;
import com.terraformersmc.biolith.api.biome.sub.CriterionType;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.sub.AbstractParameterCriterion;
import com.terraformersmc.biolith.impl.biome.sub.BiolithCriteria;
import net.minecraft.core.Holder;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;

public class DeviationCriterion
extends AbstractParameterCriterion {
    public static final MapCodec<DeviationCriterion> CODEC = DeviationCriterion.buildCodec(DeviationCriterion::new);

    public DeviationCriterion(BiomeParameterTargets parameter, float min, float max) {
        super(parameter, min, max);
    }

    public CriterionType<DeviationCriterion> getType() {
        return BiolithCriteria.DEVIATION;
    }

    public MapCodec<DeviationCriterion> getCodec() {
        return CODEC;
    }

    @Override
    public boolean matches(BiolithFittestNodes<Holder<Biome>> fittestNodes, DimensionBiomePlacement biomePlacement, Climate.TargetPoint noisePoint, @Nullable InclusiveRange<Float> replacementRange, float replacementNoise) {
        long value = this.parameter.getNoiseValue(noisePoint);
        long parameterCenter = BiomeParameterTargets.parameterCenter(this.getParameterRange(fittestNodes.ultimate().parameterSpace));
        return this.allowedValues.isValueInRange((Comparable)Float.valueOf(Climate.unquantizeCoord((long)(value - parameterCenter))));
    }

    private Climate.Parameter getParameterRange(Climate.Parameter[] parameters) {
        if (this.parameter == BiomeParameterTargets.PEAKS_VALLEYS) {
            long weirdnessMin = parameters[BiomeParameterTargets.WEIRDNESS.ordinal()].min();
            long weirdnessMax = parameters[BiomeParameterTargets.WEIRDNESS.ordinal()].max();
            long point1 = BiomeParameterTargets.getPeaksValleysNoiseLong(weirdnessMin);
            long point2 = BiomeParameterTargets.getPeaksValleysNoiseLong(weirdnessMax);
            long pvMin = (float)weirdnessMin < 0.0f && (float)weirdnessMax > 0.0f ? -10000L : Math.min(point1, point2);
            long pvMax = (float)weirdnessMin < -6666.6665f && (float)weirdnessMax > -6666.6665f || (float)weirdnessMin < 6666.6665f && (float)weirdnessMax > 6666.6665f ? 10000L : Math.max(point1, point2);
            return new Climate.Parameter(pvMin, pvMax);
        }
        if (this.parameter.ordinal() < parameters.length) {
            return parameters[this.parameter.ordinal()];
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.parameter));
    }
}

