/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.api.biome.sub.BiomeParameterTargets;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.compat.BiolithCompat;
import com.terraformersmc.biolith.impl.compat.VanillaCompat;
import com.terraformersmc.biolith.impl.platform.Services;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import org.jetbrains.annotations.Nullable;

public class BiolithDescribeCommand {
    protected static int atCaller(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"biolith.command.describe.nonPlayer").withStyle(ChatFormatting.RED));
            return -1;
        }
        return BiolithDescribeCommand.atBlockPos(context, ((CommandSourceStack)context.getSource()).getPlayerOrException().blockPosition());
    }

    protected static int atEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return BiolithDescribeCommand.atBlockPos(context, EntityArgument.getEntity(context, (String)"entity").blockPosition());
    }

    protected static int atPosition(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return BiolithDescribeCommand.atBlockPos(context, BlockPosArgument.getSpawnablePos(context, (String)"position"));
    }

    private static int atBlockPos(CommandContext<CommandSourceStack> context, BlockPos pos) {
        DescribeBiomeData describeBiomeData;
        int replacementScale;
        double replacementNoise;
        BiolithFittestNodes<Holder<Biome>> vanillaFittestNodes;
        Climate.TargetPoint noisePoint;
        int mbStatus;
        BiomeSource biomeSource;
        Climate.ParameterList biomeEntries;
        int biomeX = QuartPos.fromBlock((int)pos.getX());
        int biomeY = QuartPos.fromBlock((int)pos.getY());
        int biomeZ = QuartPos.fromBlock((int)pos.getZ());
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        if (world == null) {
            world = ((CommandSourceStack)context.getSource()).getServer().overworld();
        }
        if ((biomeEntries = (biomeSource = world.getChunkSource().getGenerator().getBiomeSource()).biolith$getBiomeEntries()) == null) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"biolith.command.describe.notOurs").withStyle(ChatFormatting.RED));
            return -1;
        }
        Climate.Sampler noise = world.getChunkSource().randomState().sampler();
        if (BiolithCompat.COMPAT_MODERN_BETA && (mbStatus = Services.PLATFORM.describeModernBeta(context, biomeX, biomeY, biomeZ, world, biomeSource, (Climate.ParameterList<Holder<Biome>>)biomeEntries, noise)) != 0) {
            return mbStatus;
        }
        BiolithFittestNodes<Object> fittestNodes = null;
        BiolithFittestNodes<Object> terrablenderFittestNodes = null;
        if (world.dimensionTypeRegistration().is(BuiltinDimensionTypes.OVERWORLD)) {
            noisePoint = noise.sample(biomeX, biomeY, biomeZ);
            vanillaFittestNodes = VanillaCompat.getBiome(noisePoint, (Climate.ParameterList<Holder<Biome>>)biomeEntries);
            if (BiolithCompat.COMPAT_TERRABLENDER) {
                terrablenderFittestNodes = Services.PLATFORM.getTerraBlenderCompat().getBiome(biomeX, biomeY, biomeZ, noisePoint, (Climate.ParameterList<Holder<Biome>>)biomeEntries);
                fittestNodes = terrablenderFittestNodes;
            }
            if (fittestNodes == null) {
                fittestNodes = vanillaFittestNodes;
            }
            replacementNoise = BiomeCoordinator.OVERWORLD.getLocalNoise(biomeX, biomeY, biomeZ);
            replacementScale = Biolith.getConfigManager().getGeneralConfig().getOverworldReplacementScale();
            describeBiomeData = BiomeCoordinator.OVERWORLD.getBiomeData(biomeX, biomeY, biomeZ, noisePoint, fittestNodes);
        } else if (world.dimensionTypeRegistration().is(BuiltinDimensionTypes.NETHER)) {
            noisePoint = noise.sample(biomeX, biomeY, biomeZ);
            vanillaFittestNodes = VanillaCompat.getBiome(noisePoint, (Climate.ParameterList<Holder<Biome>>)biomeEntries);
            if (BiolithCompat.COMPAT_TERRABLENDER) {
                terrablenderFittestNodes = Services.PLATFORM.getTerraBlenderCompat().getBiome(biomeX, biomeY, biomeZ, noisePoint, (Climate.ParameterList<Holder<Biome>>)biomeEntries);
                fittestNodes = terrablenderFittestNodes;
            }
            if (fittestNodes == null) {
                fittestNodes = vanillaFittestNodes;
            }
            replacementNoise = BiomeCoordinator.NETHER.getLocalNoise(biomeX, biomeY, biomeZ);
            replacementScale = Biolith.getConfigManager().getGeneralConfig().getNetherReplacementScale();
            describeBiomeData = BiomeCoordinator.NETHER.getBiomeData(biomeX, biomeY, biomeZ, noisePoint, fittestNodes);
        } else if (world.dimensionTypeRegistration().is(BuiltinDimensionTypes.END)) {
            Holder<Biome> original = VanillaCompat.getOriginalEndBiome(biomeX, biomeY, biomeZ, noise);
            noisePoint = BiomeCoordinator.END.sampleEndNoise(biomeX, biomeY, biomeZ, noise, original);
            vanillaFittestNodes = VanillaCompat.getEndBiome(noisePoint, (Climate.ParameterList<Holder<Biome>>)biomeEntries, original);
            if (BiolithCompat.COMPAT_TERRABLENDER) {
                biomeSource.biolith$setBypass(true);
                terrablenderFittestNodes = new BiolithFittestNodes(new Climate.RTree.Leaf(DimensionBiomePlacement.OUT_OF_RANGE, (Object)biomeSource.getNoiseBiome(biomeX, biomeY, biomeZ, noise)), 0L);
                fittestNodes = terrablenderFittestNodes;
                biomeSource.biolith$setBypass(false);
            }
            if (fittestNodes == null) {
                fittestNodes = vanillaFittestNodes;
            }
            replacementNoise = BiomeCoordinator.END.getLocalNoise(biomeX, biomeY, biomeZ);
            replacementScale = Biolith.getConfigManager().getGeneralConfig().getEndReplacementScale();
            describeBiomeData = BiomeCoordinator.END.getBiomeData(biomeX, biomeY, biomeZ, noisePoint, fittestNodes);
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"biolith.command.describe.notOurs").withStyle(ChatFormatting.RED));
            return -1;
        }
        String worldTranslationKey = world.dimension().location().toLanguageKey();
        if (worldTranslationKey.equals("minecraft.overworld")) {
            worldTranslationKey = "biolith.world.minecraft.overworld";
        } else if (worldTranslationKey.equals("minecraft.the_nether")) {
            worldTranslationKey = "biolith.world.minecraft.the_nether";
        } else if (worldTranslationKey.equals("minecraft.the_end")) {
            worldTranslationKey = "biolith.world.minecraft.the_end";
        }
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"\u00a7nBiolith ").append((Component)Component.translatable((String)worldTranslationKey).withStyle(ChatFormatting.UNDERLINE)).append((Component)Component.literal((String)"\u00a7n (")).append((Component)Component.translatable((String)"biolith.command.describe.biome.scale").withStyle(ChatFormatting.UNDERLINE)).append((Component)Component.literal((String)("\u00a7n: " + replacementScale + ") "))).append((Component)Component.translatable((String)"biolith.command.describe.header").withStyle(ChatFormatting.UNDERLINE)));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("\u00a72Co\u00a7r:%+05.3f  \u00a78De\u00a7r:%+05.3f  \u00a7cEr\u00a7r:%+05.3f  \u00a71Hu\u00a7r:%+05.3f", Float.valueOf(Climate.unquantizeCoord((long)noisePoint.continentalness())), Float.valueOf(Climate.unquantizeCoord((long)noisePoint.depth())), Float.valueOf(Climate.unquantizeCoord((long)noisePoint.erosion())), Float.valueOf(Climate.unquantizeCoord((long)noisePoint.humidity())))));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("\u00a77PV\u00a7r:%+05.3f  \u00a74Te\u00a7r:%+05.3f  \u00a75We\u00a7r:%+05.3f  \u00a76BR\u00a7r:%+05.3f", Float.valueOf(Climate.unquantizeCoord((long)BiomeParameterTargets.getPeaksValleysNoiseLong(noisePoint.weirdness()))), Float.valueOf(Climate.unquantizeCoord((long)noisePoint.temperature())), Float.valueOf(Climate.unquantizeCoord((long)noisePoint.weirdness())), replacementNoise)));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"biolith.command.describe.biome.vanilla").append((Component)BiolithDescribeCommand.textFromFittestNodes(vanillaFittestNodes)));
        if (terrablenderFittestNodes != null) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"biolith.command.describe.biome.terrablender").append((Component)BiolithDescribeCommand.textFromFittestNodes(terrablenderFittestNodes)));
        }
        if (describeBiomeData.replacementBiome != null && describeBiomeData.replacementRange == null) {
            return -2;
        }
        if (describeBiomeData.replacementBiome != null) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"biolith.command.describe.biome.replacement").append((Component)BiolithDescribeCommand.textFromBiome(describeBiomeData.replacementBiome)).append((Component)Component.literal((String)"\n    ")).append((Component)(describeBiomeData.lowerBiome == null ? Component.translatable((String)"biolith.command.describe.biome.none") : BiolithDescribeCommand.textFromBiome(describeBiomeData.lowerBiome))).append((Component)Component.literal((String)" < ")).append((Component)BiolithDescribeCommand.textFromBiome(describeBiomeData.replacementBiome)).append((Component)Component.literal((String)" < ")).append((Component)(describeBiomeData.higherBiome == null ? Component.translatable((String)"biolith.command.describe.biome.none") : BiolithDescribeCommand.textFromBiome(describeBiomeData.higherBiome))).append((Component)Component.literal((String)String.format("\n    %+05.3f < %+05.3f < %+05.3f ", describeBiomeData.replacementRange.minInclusive(), replacementNoise, describeBiomeData.replacementRange.maxInclusive()))));
        }
        if (describeBiomeData.subBiome != null) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"biolith.command.describe.biome.sub").append((Component)BiolithDescribeCommand.textFromBiome(describeBiomeData.subBiome)));
        }
        return 1;
    }

    public static MutableComponent textFromFittestNodes(BiolithFittestNodes<Holder<Biome>> fittestNodes) {
        MutableComponent text = BiolithDescribeCommand.textFromBiome(fittestNodes.ultimate());
        if (fittestNodes.penultimate() != null) {
            text = text.append((Component)Component.literal((String)"\n    ")).append((Component)Component.translatable((String)"biolith.command.describe.biome.nearest")).append((Component)BiolithDescribeCommand.textFromBiome(fittestNodes.penultimate())).append(" (+" + (fittestNodes.penultimateDistance() - fittestNodes.ultimateDistance()) + ")");
        }
        return text;
    }

    public static MutableComponent textFromBiome(Climate.RTree.Leaf<Holder<Biome>> leafNode) {
        return BiolithDescribeCommand.textFromBiome((ResourceKey<Biome>)((ResourceKey)((Holder)leafNode.value).unwrapKey().orElseThrow()));
    }

    public static MutableComponent textFromBiome(Holder<Biome> biome) {
        return BiolithDescribeCommand.textFromBiome((ResourceKey<Biome>)((ResourceKey)biome.unwrapKey().orElseThrow()));
    }

    public static MutableComponent textFromBiome(ResourceKey<Biome> biome) {
        return Component.translatable((String)biome.location().toLanguageKey("biome"));
    }

    public record DescribeBiomeData(@Nullable InclusiveRange<Float> replacementRange, @Nullable ResourceKey<Biome> replacementBiome, @Nullable ResourceKey<Biome> lowerBiome, @Nullable ResourceKey<Biome> higherBiome, @Nullable ResourceKey<Biome> subBiome) {
    }
}

