/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.compat;

import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.apache.commons.lang3.function.TriFunction;

public class VanillaCompat {
    public static BiolithFittestNodes<Holder<Biome>> getBiome(Climate.TargetPoint noisePoint, Climate.ParameterList<Holder<Biome>> entries) {
        return entries.index.biolith$searchTreeGet(noisePoint, Climate.RTree.Node::distance);
    }

    public static BiolithFittestNodes<Holder<Biome>> getEndBiome(Climate.TargetPoint noisePoint, Climate.ParameterList<Holder<Biome>> entries, Holder<Biome> original) {
        BiolithFittestNodes fittestNodes;
        if (original.is(Biomes.THE_END)) {
            Climate.RTree.Leaf ultimate = new Climate.RTree.Leaf(new Climate.ParameterPoint(Climate.Parameter.point((float)Climate.unquantizeCoord((long)noisePoint.temperature())), Climate.Parameter.point((float)Climate.unquantizeCoord((long)noisePoint.humidity())), Climate.Parameter.point((float)Climate.unquantizeCoord((long)noisePoint.continentalness())), Climate.Parameter.point((float)Climate.unquantizeCoord((long)noisePoint.erosion())), Climate.Parameter.point((float)Climate.unquantizeCoord((long)noisePoint.depth())), Climate.Parameter.point((float)Climate.unquantizeCoord((long)noisePoint.weirdness())), 0L), original);
            fittestNodes = new BiolithFittestNodes(ultimate, 0L);
        } else {
            fittestNodes = entries.index.biolith$searchTreeGet(noisePoint, Climate.RTree.Node::distance);
        }
        if (!original.equals(fittestNodes.ultimate().value) && (((Holder)fittestNodes.ultimate().value).is(Biomes.SMALL_END_ISLANDS) || ((Holder)fittestNodes.ultimate().value).is(Biomes.END_BARRENS) || ((Holder)fittestNodes.ultimate().value).is(Biomes.END_MIDLANDS) || ((Holder)fittestNodes.ultimate().value).is(Biomes.END_HIGHLANDS))) {
            fittestNodes = new BiolithFittestNodes(new Climate.RTree.Leaf(VanillaCompat.createNoiseHypercube(fittestNodes.ultimate().parameterSpace), original), 0L, fittestNodes.ultimate(), fittestNodes.ultimateDistance());
        }
        return fittestNodes;
    }

    public static Holder<Biome> getOriginalEndBiome(int biomeX, int biomeY, int biomeZ, Climate.Sampler noise) {
        double erosion;
        int x = QuartPos.toBlock((int)biomeX);
        int y = QuartPos.toBlock((int)biomeY);
        int z = QuartPos.toBlock((int)biomeZ);
        Holder biomeEntry = Mth.square((long)SectionPos.blockToSectionCoord((int)x)) + Mth.square((long)SectionPos.blockToSectionCoord((int)z)) <= 4096L ? (Holder)BiomeCoordinator.END.nodeTheEnd.value : ((erosion = noise.erosion().compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z))) > 0.25 ? (Holder)BiomeCoordinator.END.nodeEndHighlands.value : (erosion >= -0.0625 ? (Holder)BiomeCoordinator.END.nodeEndMidlands.value : (erosion < -0.21875 ? (Holder)BiomeCoordinator.END.nodeSmallEndIslands.value : (Holder)BiomeCoordinator.END.nodeEndBarrens.value)));
        return biomeEntry;
    }

    private static Climate.ParameterPoint createNoiseHypercube(Climate.Parameter ... parameters) {
        return Climate.parameters((Climate.Parameter)parameters[0], (Climate.Parameter)parameters[1], (Climate.Parameter)parameters[2], (Climate.Parameter)parameters[3], (Climate.Parameter)parameters[4], (Climate.Parameter)parameters[5], (float)parameters[6].min());
    }

    public static Holder<Biome> callFunctionWithSmoothedBiomeCoords(TriFunction<Integer, Integer, Integer, Holder<Biome>> function, BlockPos pos, long seed) {
        int centerX = pos.getX() - 2;
        int centerY = pos.getY() - 2;
        int centerZ = pos.getZ() - 2;
        int biomeX = centerX >> 2;
        int biomeY = centerY >> 2;
        int biomeZ = centerZ >> 2;
        double fractionalX = (double)(centerX & 3) / 4.0;
        double fractionalY = (double)(centerY & 3) / 4.0;
        double fractionalZ = (double)(centerZ & 3) / 4.0;
        int offsets = 0;
        double minimum = Double.POSITIVE_INFINITY;
        for (int option = 0; option < 8; ++option) {
            boolean offsetZ;
            boolean offsetY;
            boolean offsetX = (option & 4) == 0;
            double preference = BiomeManager.getFiddledDistance((long)seed, (int)(offsetX ? biomeX : biomeX + 1), (int)((offsetY = (option & 2) == 0) ? biomeY : biomeY + 1), (int)((offsetZ = (option & 1) == 0) ? biomeZ : biomeZ + 1), (double)(offsetX ? fractionalX : fractionalX - 1.0), (double)(offsetY ? fractionalY : fractionalY - 1.0), (double)(offsetZ ? fractionalZ : fractionalZ - 1.0));
            if (!(minimum > preference)) continue;
            minimum = preference;
            offsets = option;
        }
        return (Holder)function.apply((Object)((offsets & 4) == 0 ? biomeX : biomeX + 1), (Object)((offsets & 2) == 0 ? biomeY : biomeY + 1), (Object)((offsets & 1) == 0 ? biomeZ : biomeZ + 1));
    }
}

