/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.config;

import com.terraformersmc.biolith.impl.Biolith;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;

public class BiolithState
extends SavedData {
    private final LinkedHashMap<ResourceKey<Biome>, LinkedHashSet<ResourceKey<Biome>>> biomeReplacements = new LinkedHashMap(64);
    private final ServerLevel world;
    private final String stateId;
    private static final int STATE_VERSION = 0;

    public BiolithState(ServerLevel serverWorld, String name) {
        this.world = serverWorld;
        this.stateId = "biolith_" + name + "_state";
        this.world.getDataStorage().set(this.stateId, (SavedData)this);
        this.readState();
    }

    private void writeState() {
        this.setDirty();
        this.world.getDataStorage().save();
    }

    private void readState() {
        CompoundTag nbt = null;
        CompoundTag nbtState = null;
        try {
            nbt = this.world.getDataStorage().readTagFromDisk(this.stateId, DataFixTypes.LEVEL, 0);
        }
        catch (IOException e) {
            Biolith.LOGGER.debug("No saved state found for {}; starting anew...", (Object)this.stateId);
        }
        if (nbt != null && nbt.contains("data")) {
            int nbtVersion = nbt.getInt("DataVersion");
            nbtState = nbt.getCompound("data");
        }
        this.biomeReplacements.clear();
        if (nbtState != null && !nbtState.isEmpty()) {
            ListTag biomeReplacementsNbt = nbtState.getList("BiomeReplacementsList", 9);
            biomeReplacementsNbt.forEach(nbtElement -> {
                ListTag replacementsNbt = (ListTag)nbtElement.copy();
                ResourceLocation elementId = ResourceLocation.tryParse((String)replacementsNbt.getString(0));
                if (elementId == null) {
                    Biolith.LOGGER.warn("{}: Failed to parse target biome identifier from NBT: {}", (Object)this.stateId, (Object)replacementsNbt.getString(0));
                } else if (replacementsNbt.size() < 2) {
                    Biolith.LOGGER.warn("{}: Replacements list from NBT contains no replacements: {}", (Object)this.stateId, (Object)replacementsNbt.getString(0));
                } else {
                    ResourceKey target = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)elementId);
                    replacementsNbt.remove(0);
                    this.biomeReplacements.put((ResourceKey<Biome>)target, replacementsNbt.stream().map(element -> ResourceLocation.tryParse((String)element.getAsString())).filter(Objects::nonNull).map(id -> ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)id)).collect(Collectors.toCollection(LinkedHashSet::new)));
                    Biolith.LOGGER.debug("{}: Resolved replacements list from NBT: {} -> {}", new Object[]{this.stateId, target.location(), this.biomeReplacements.get(target).stream().map(ResourceKey::location).toList()});
                }
            });
        }
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ListTag biomeReplacementsNbt = new ListTag();
        this.biomeReplacements.forEach((target, replacements) -> {
            ListTag replacementsNbt = new ListTag();
            replacementsNbt.add((Object)StringTag.valueOf((String)target.location().toString()));
            replacementsNbt.addAll(replacements.stream().map(replacement -> StringTag.valueOf((String)replacement.location().toString())).toList());
            biomeReplacementsNbt.add((Object)replacementsNbt);
        });
        Biolith.LOGGER.debug("{}: Describing biome replacemnts NBT:\n{}", (Object)this.stateId, (Object)biomeReplacementsNbt);
        nbt.put("BiomeReplacementsList", (Tag)biomeReplacementsNbt);
        return nbt;
    }

    public Stream<ResourceKey<Biome>> getBiomeReplacements(ResourceKey<Biome> target) {
        if (this.biomeReplacements.containsKey(target)) {
            return this.biomeReplacements.get(target).stream();
        }
        return Stream.empty();
    }

    public void addBiomeReplacements(ResourceKey<Biome> target, Stream<ResourceKey<Biome>> replacements) {
        if (this.biomeReplacements.containsKey(target)) {
            replacements.forEachOrdered(this.biomeReplacements.get(target)::add);
        } else {
            this.biomeReplacements.put(target, replacements.collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        this.setDirty();
    }

    public ResourceLocation getDimensionId() {
        if (this.world.dimensionTypeRegistration().unwrapKey().isEmpty()) {
            return ResourceLocation.fromNamespaceAndPath((String)"biolith", (String)"unregistered_dimension");
        }
        return ((ResourceKey)this.world.dimensionTypeRegistration().unwrapKey().get()).location();
    }

    public ResourceLocation getWorldId() {
        return this.world.dimension().location();
    }
}

