/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Either;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.compat.BiolithCompat;
import com.terraformersmc.biolith.impl.compat.VanillaCompat;
import com.terraformersmc.biolith.impl.platform.Services;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiNoiseBiomeSource.class}, priority=900)
public abstract class MixinMultiNoiseBiomeSource
extends BiomeSource {
    private Climate.ParameterList<Holder<Biome>> biolith$biomeEntries;

    @Shadow
    protected abstract Climate.ParameterList<Holder<Biome>> parameters();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"parameters()Lnet/minecraft/world/level/biome/Climate$ParameterList;"}, at={@At(value="INVOKE", target="Lcom/mojang/datafixers/util/Either;map(Ljava/util/function/Function;Ljava/util/function/Function;)Ljava/lang/Object;")})
    private Object biolith$injectEntries(Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>> instance, Function<Climate.ParameterList<Holder<Biome>>, Climate.ParameterList<Holder<Biome>>> leftMap, Function<Holder<MultiNoiseBiomeSourceParameterList>, Climate.ParameterList<Holder<Biome>>> rightMap, Operation<Object> original) {
        MixinMultiNoiseBiomeSource mixinMultiNoiseBiomeSource = this;
        synchronized (mixinMultiNoiseBiomeSource) {
            if (this.biolith$biomeEntries == null) {
                Climate.ParameterList originalEntries = (Climate.ParameterList)original.call(new Object[]{instance, leftMap, rightMap});
                if (this.biolith$getDimensionType().location().equals((Object)BuiltinDimensionTypes.OVERWORLD.location())) {
                    ArrayList parameterList = new ArrayList(256);
                    originalEntries.values().stream().filter(BiomeCoordinator.OVERWORLD::removalFilter).forEach(parameterList::add);
                    BiomeCoordinator.OVERWORLD.writeBiomeEntries(parameterList::add);
                    this.biolith$biomeEntries = new Climate.ParameterList(parameterList);
                } else if (this.biolith$getDimensionType().location().equals((Object)BuiltinDimensionTypes.NETHER.location())) {
                    ArrayList parameterList = new ArrayList(64);
                    originalEntries.values().stream().filter(BiomeCoordinator.NETHER::removalFilter).forEach(parameterList::add);
                    BiomeCoordinator.NETHER.writeBiomeEntries(parameterList::add);
                    this.biolith$biomeEntries = new Climate.ParameterList(parameterList);
                } else {
                    this.biolith$biomeEntries = originalEntries;
                }
            }
        }
        return this.biolith$biomeEntries;
    }

    @Inject(method={"getNoiseBiome(IIILnet/minecraft/world/level/biome/Climate$Sampler;)Lnet/minecraft/core/Holder;"}, at={@At(value="HEAD")}, cancellable=true)
    private void biolith$getBiome(int x, int y, int z, Climate.Sampler noise, CallbackInfoReturnable<Holder<Biome>> cir) {
        Climate.TargetPoint noisePoint = noise.sample(x, y, z);
        BiolithFittestNodes<Holder<Biome>> fittestNodes = null;
        if (BiolithCompat.COMPAT_TERRABLENDER) {
            fittestNodes = Services.PLATFORM.getTerraBlenderCompat().getBiome(x, y, z, noisePoint, this.parameters());
        }
        if (fittestNodes == null) {
            fittestNodes = VanillaCompat.getBiome(noisePoint, this.parameters());
        }
        if (this.biolith$getDimensionType().location().equals((Object)BuiltinDimensionTypes.OVERWORLD.location())) {
            cir.setReturnValue(BiomeCoordinator.OVERWORLD.getReplacement(x, y, z, noisePoint, fittestNodes));
        } else if (this.biolith$getDimensionType().location().equals((Object)BuiltinDimensionTypes.NETHER.location())) {
            cir.setReturnValue(BiomeCoordinator.NETHER.getReplacement(x, y, z, noisePoint, fittestNodes));
        } else {
            cir.setReturnValue((Object)((Holder)fittestNodes.ultimate().value));
        }
    }

    public Climate.ParameterList<Holder<Biome>> biolith$getBiomeEntries() {
        return this.biolith$biomeEntries;
    }
}

