/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.mixin;

import com.google.common.collect.Streams;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.VanillaEndBiomeParameters;
import com.terraformersmc.biolith.impl.compat.BiolithCompat;
import com.terraformersmc.biolith.impl.compat.VanillaCompat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TheEndBiomeSource.class}, priority=990)
public abstract class MixinTheEndBiomeSource
extends BiomeSource {
    private static HolderGetter<Biome> biolith$biomeLookup;
    private static Climate.ParameterList<Holder<Biome>> biolith$biomeEntries;

    @Inject(method={"create(Lnet/minecraft/core/HolderGetter;)Lnet/minecraft/world/level/biome/TheEndBiomeSource;"}, at={@At(value="HEAD")})
    private static void biolith$getRegistry(HolderGetter<Biome> biomeLookup, CallbackInfoReturnable<TheEndBiomeSource> cir) {
        if (!biomeLookup.equals(biolith$biomeLookup)) {
            biolith$biomeLookup = biomeLookup;
            biolith$biomeEntries = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ModifyReturnValue(method={"collectPossibleBiomes()Ljava/util/stream/Stream;"}, at={@At(value="RETURN")})
    private Stream<Holder<Biome>> biolith$biomeStream(Stream<Holder<Biome>> original) {
        if (BiolithCompat.COMPAT_DATAGEN) {
            return original;
        }
        MixinTheEndBiomeSource mixinTheEndBiomeSource = this;
        synchronized (mixinTheEndBiomeSource) {
            if (biolith$biomeEntries == null) {
                ArrayList<Pair> parameterList = new ArrayList<Pair>(64);
                BiomeCoordinator.getBiomeLookup().ifPresent(lookup -> {
                    biolith$biomeLookup = lookup;
                });
                Objects.requireNonNull(biolith$biomeLookup, "Failed to acquire biome lookup for The End.");
                VanillaEndBiomeParameters.writeEndBiomeParameters(parameterList::add);
                parameterList.removeIf(entry -> !BiomeCoordinator.END.removalFilter((Pair<Climate.ParameterPoint, Holder<Biome>>)entry.mapSecond(key -> biolith$biomeLookup.getOrThrow(key))));
                BiomeCoordinator.END.writeBiomeParameters(parameterList::add);
                biolith$biomeEntries = new Climate.ParameterList(parameterList.stream().map(pair -> pair.mapSecond(key -> biolith$biomeLookup.getOrThrow(key))).toList());
            }
        }
        return Streams.concat((Stream[])new Stream[]{original, biolith$biomeEntries.values().stream().map(Pair::getSecond)}).distinct();
    }

    @ModifyReturnValue(method={"getNoiseBiome(IIILnet/minecraft/world/level/biome/Climate$Sampler;)Lnet/minecraft/core/Holder;"}, at={@At(value="RETURN")})
    private Holder<Biome> biolith$getBiome(Holder<Biome> original, int x, int y, int z, Climate.Sampler noise) {
        Climate.TargetPoint noisePoint = BiomeCoordinator.END.sampleEndNoise(x, y, z, noise, original);
        BiolithFittestNodes<Holder<Biome>> fittestNodes = VanillaCompat.getEndBiome(noisePoint, this.biolith$getBiomeEntries(), original);
        return BiomeCoordinator.END.getReplacement(x, y, z, noisePoint, fittestNodes);
    }

    @WrapOperation(method={"getNoiseBiome(IIILnet/minecraft/world/level/biome/Climate$Sampler;)Lnet/minecraft/core/Holder;"}, at={@At(value="NEW", target="Lnet/minecraft/world/level/levelgen/DensityFunction$SinglePointContext;")})
    private DensityFunction.SinglePointContext biolith$smoothEndNoise(int blockX, int blockY, int blockZ, Operation<DensityFunction.SinglePointContext> original, int x, int y, int z) {
        return new DensityFunction.SinglePointContext(QuartPos.toBlock((int)x), QuartPos.toBlock((int)y), QuartPos.toBlock((int)z));
    }

    @NotNull
    public Climate.ParameterList<Holder<Biome>> biolith$getBiomeEntries() {
        if (biolith$biomeEntries == null) {
            this.collectPossibleBiomes();
            if (biolith$biomeEntries == null) {
                throw new IllegalStateException("biolith$biomeEntries is null after call to " + ((Object)((Object)this)).getClass().getCanonicalName() + ".biomeStream()");
            }
        }
        return biolith$biomeEntries;
    }
}

