/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.createores.util.DimChunkPos;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public record OreVeinAtlasDataComponent(List<ResourceLocation> discovered, List<Pair<DimChunkPos, OreVeinData>> veins, List<ResourceLocation> exclude, Optional<ResourceLocation> target) {
    public static final Codec<OreVeinAtlasDataComponent> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("discovered").forGetter(OreVeinAtlasDataComponent::discovered), (App)Codec.list((Codec)Codec.pair(DimChunkPos.CODEC, OreVeinData.CODEC)).fieldOf("veins").forGetter(OreVeinAtlasDataComponent::veins), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("exclude").forGetter(OreVeinAtlasDataComponent::exclude), (App)ResourceLocation.CODEC.optionalFieldOf("target").forGetter(OreVeinAtlasDataComponent::target)).apply((Applicative)b, OreVeinAtlasDataComponent::new)).codec();

    public record OreVeinData(ResourceLocation id, float size, boolean hide) {
        public static final Codec<OreVeinData> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(OreVeinData::id), (App)Codec.FLOAT.fieldOf("size").forGetter(OreVeinData::size), (App)Codec.BOOL.fieldOf("hide").forGetter(OreVeinData::hide)).apply((Applicative)b, OreVeinData::new)).codec();
    }

    public static class OreVeinAtlasData {
        private boolean edited;
        private List<ResourceLocation> discovered;
        private Map<DimChunkPos, OreVeinData> veins;
        private List<ResourceLocation> exclude;
        private ResourceLocation target;
        private List<Pair<DimChunkPos, OreVeinData>> veinsIndex;

        public OreVeinAtlasData(OreVeinAtlasDataComponent comp) {
            if (comp == null) {
                this.discovered = Collections.emptyList();
                this.veins = Collections.emptyMap();
                this.exclude = Collections.emptyList();
                this.veinsIndex = Collections.emptyList();
            } else {
                this.discovered = comp.discovered();
                this.veins = (Map)comp.veins().stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> {
                    throw new IllegalStateException();
                }, Object2ObjectArrayMap::new));
                this.exclude = comp.exclude();
                this.target = comp.target().orElse(null);
                this.veinsIndex = comp.veins();
            }
        }

        private void makeEdited() {
            if (this.edited) {
                return;
            }
            this.discovered = new ArrayList<ResourceLocation>(this.discovered);
            this.veins = new Object2ObjectArrayMap(this.veins);
            this.exclude = new ArrayList<ResourceLocation>(this.exclude);
            this.veinsIndex = new ArrayList<Pair<DimChunkPos, OreVeinData>>(this.veinsIndex);
            this.edited = true;
        }

        public void addDiscovered(ResourceLocation id) {
            this.makeEdited();
            this.discovered.add(id);
        }

        public List<ResourceLocation> discovered() {
            return this.discovered;
        }

        public Map<DimChunkPos, OreVeinData> veins() {
            return this.veins;
        }

        public void addVein(DimChunkPos pos, OreVeinData oreVeinData) {
            this.makeEdited();
            this.veins.put(pos, oreVeinData);
        }

        public boolean isEdited() {
            return this.edited;
        }

        public void addExclude(ResourceLocation id) {
            if (this.exclude.contains(id)) {
                return;
            }
            this.makeEdited();
            this.exclude.add(id);
        }

        public void removeExclude(ResourceLocation id) {
            this.makeEdited();
            this.exclude.remove(id);
        }

        public void setTarget(ResourceLocation target) {
            this.makeEdited();
            this.target = target;
        }

        public void toggleHide(int id) {
            DimChunkPos vein = (DimChunkPos)this.veinsIndex.get(id).getFirst();
            OreVeinData vd = this.veins.get(vein);
            if (vd == null) {
                return;
            }
            this.makeEdited();
            this.veins.put(vein, new OreVeinData(vd.id(), vd.size(), !vd.hide()));
        }

        public OreVeinAtlasDataComponent finish() {
            return new OreVeinAtlasDataComponent(this.discovered, this.veins.entrySet().stream().map(e -> Pair.of((Object)((DimChunkPos)e.getKey()), (Object)((OreVeinData)e.getValue()))).collect(Collectors.toList()), this.exclude, Optional.ofNullable(this.target));
        }
    }
}

