/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class DimChunkPos {
    private final ResourceKey<Level> dimension;
    private final int x;
    private final int z;
    private int hash;
    public static final Codec<DimChunkPos> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(DimChunkPos::dimension), (App)Codec.INT.fieldOf("x").forGetter(DimChunkPos::x), (App)Codec.INT.fieldOf("z").forGetter(DimChunkPos::z)).apply((Applicative)b, DimChunkPos::new)).codec();

    public DimChunkPos(ResourceKey<Level> dimension, int x, int z) {
        this.dimension = dimension;
        this.x = x;
        this.z = z;
    }

    public DimChunkPos(Level level, ChunkPos p) {
        this((ResourceKey<Level>)level.dimension(), p.x, p.z);
    }

    public DimChunkPos(Level level, BlockPos p) {
        this(level, new ChunkPos(p));
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.dimension.location(), this.x, this.z);
            if (this.hash == 0) {
                this.hash = 1;
            }
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DimChunkPos)) {
            return false;
        }
        DimChunkPos p = (DimChunkPos)obj;
        return this.dimension == p.dimension && this.x == p.x && this.z == p.z;
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    public int x() {
        return this.x;
    }

    public int z() {
        return this.z;
    }
}

