/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.List;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.vanilla_input.BiChemicalRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class ChemicalChemicalToChemicalRecipe
extends MekanismRecipe<BiChemicalRecipeInput>
implements BiPredicate<ChemicalStack, ChemicalStack> {
    @Override
    public abstract boolean test(ChemicalStack var1, ChemicalStack var2);

    public boolean matches(BiChemicalRecipeInput input, Level level) {
        return !this.isIncomplete() && this.test(input.left(), input.right());
    }

    @Contract(value="_, _ -> new", pure=true)
    public abstract ChemicalStack getOutput(ChemicalStack var1, ChemicalStack var2);

    public abstract ChemicalStackIngredient getLeftInput();

    public abstract ChemicalStackIngredient getRightInput();

    public abstract List<ChemicalStack> getOutputDefinition();

    @Override
    public boolean isIncomplete() {
        return this.getLeftInput().hasNoMatchingInstances() || this.getRightInput().hasNoMatchingInstances();
    }

    @Override
    public void logMissingTags() {
        this.getLeftInput().logMissingTags();
        this.getRightInput().logMissingTags();
    }
}

